/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.bytestringcodec;

import io.datarouter.bytes.codec.bytestringcodec.ByteStringCodec;
import java.util.Objects;

public class CsvIntByteStringCodec
implements ByteStringCodec {
    public static final CsvIntByteStringCodec INSTANCE = new CsvIntByteStringCodec();

    @Override
    public String encode(byte[] bytes) {
        Objects.requireNonNull(bytes);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(Byte.toUnsignedInt(bytes[i]));
            ++i;
        }
        return sb.toString();
    }

    @Override
    public byte[] decode(String csv) {
        Objects.requireNonNull(csv);
        String[] tokens = csv.split(",");
        byte[] bytes = new byte[tokens.length];
        int i = 0;
        while (i < tokens.length) {
            int intValue = Integer.valueOf(tokens[i]);
            if (intValue < 0 || intValue > 255) {
                String message = String.format("Invalid value=%s must be between 0 and 255", intValue);
                throw new IllegalArgumentException(message);
            }
            bytes[i] = (byte)intValue;
            ++i;
        }
        return bytes;
    }
}

