/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.array.bytearray;

import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.TerminatedByteArrayTool;

public class TerminatedByteArrayCodec {
    public static final TerminatedByteArrayCodec INSTANCE = new TerminatedByteArrayCodec();

    public byte[] encode(byte[] value) {
        return TerminatedByteArrayTool.escapeAndTerminate(value);
    }

    public LengthAndValue<byte[]> decode(byte[] bytes, int offset) {
        TerminatedByteArrayTool.NumEscapedAndTerminalIndex numEscapedAndTerminalIndex = TerminatedByteArrayTool.findEscapedCountAndTerminalIndex(bytes, offset);
        int numEscaped = numEscapedAndTerminalIndex.numEscaped;
        int terminalIndex = numEscapedAndTerminalIndex.terminalIndex;
        int consumedLength = terminalIndex - offset + 1;
        byte[] value = TerminatedByteArrayTool.unescapeAndUnterminate(bytes, offset, numEscaped, terminalIndex);
        return new LengthAndValue<byte[]>(consumedLength, value);
    }

    public int lengthWithTerminalIndex(byte[] bytes, int offset) {
        return TerminatedByteArrayTool.lengthWithTerminator(bytes, offset);
    }
}

