/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.row;

import io.datarouter.bytes.blockfile.row.BlockfileRowOp;
import io.datarouter.bytes.blockfile.row.BlockfileRowVersion;
import io.datarouter.bytes.varint.VarIntTool;

public class BlockfileRowVersionCodec {
    public static int length(byte[] key, byte[] version) {
        return VarIntTool.length(key.length) + key.length + VarIntTool.length(version.length) + version.length + 1;
    }

    public static BlockfileRowVersion create(byte[] key, byte[] version, BlockfileRowOp op) {
        int keyLengthOffset = 0;
        int keyOffset = keyLengthOffset + VarIntTool.length(key.length);
        int versionLengthOffset = keyOffset + key.length;
        int versionOffset = versionLengthOffset + VarIntTool.length(version.length);
        int opOffset = versionOffset + version.length;
        int length = opOffset + 1;
        byte[] bytes = new byte[length];
        BlockfileRowVersionCodec.encodeInto(key, version, op, bytes, 0);
        return new BlockfileRowVersion(bytes, 0, length, keyOffset, key.length, versionOffset, version.length, op);
    }

    public static byte[] encode(byte[] key, byte[] version, BlockfileRowOp op) {
        int length = BlockfileRowVersionCodec.length(key, version);
        byte[] intoBytes = new byte[length];
        BlockfileRowVersionCodec.encodeInto(key, version, op, intoBytes, 0);
        return intoBytes;
    }

    public static void encodeInto(byte[] key, byte[] version, BlockfileRowOp op, byte[] intoBytes, int offset) {
        int cursor = offset;
        cursor += VarIntTool.encode(intoBytes, cursor, key.length);
        System.arraycopy(key, 0, intoBytes, cursor, key.length);
        cursor += key.length;
        cursor += VarIntTool.encode(intoBytes, cursor, version.length);
        System.arraycopy(version, 0, intoBytes, cursor, version.length);
        intoBytes[cursor += version.length] = op.persistentValue;
        ++cursor;
    }

    public static BlockfileRowVersion fromBytes(byte[] bytes, int offset) {
        int cursor = offset;
        int keyLength = VarIntTool.decodeInt(bytes, cursor);
        int keyOffset = cursor += VarIntTool.length(keyLength);
        int versionLength = VarIntTool.decodeInt(bytes, cursor += keyLength);
        int versionOffset = cursor += VarIntTool.length(versionLength);
        BlockfileRowOp op = BlockfileRowOp.fromByte(bytes[cursor += versionLength]);
        int length = ++cursor - offset;
        return new BlockfileRowVersion(bytes, offset, length, keyOffset, keyLength, versionOffset, versionLength, op);
    }

    public static BlockfileRowVersion fromBytes(byte[] bytes) {
        return BlockfileRowVersionCodec.fromBytes(bytes, 0);
    }
}

