/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.write;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.blockfile.block.tokens.BlockfileIndexTokens;
import io.datarouter.bytes.blockfile.encoding.indexblock.BlockfileIndexBlockCodec;
import io.datarouter.bytes.blockfile.index.BlockfileByteRange;
import io.datarouter.bytes.blockfile.index.BlockfileIndexBlockInput;
import io.datarouter.bytes.blockfile.index.BlockfileIndexEntry;
import io.datarouter.bytes.blockfile.index.BlockfileRowIdRange;
import io.datarouter.bytes.blockfile.index.BlockfileRowRange;
import io.datarouter.bytes.blockfile.index.BlockfileValueBlockIdRange;
import io.datarouter.bytes.blockfile.io.write.BlockfileIndexBlockBuilder;
import io.datarouter.bytes.blockfile.io.write.BlockfileWriterState;
import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class BlockfileIndexer {
    private final BlockfileWriterState writerState;
    private final int maxRecordsPerLevel;
    private final Optional<ByteLength> optTargetBlockSize;
    private final BlockfileIndexBlockCodec indexBlockCodec;
    private final List<BlockfileIndexBlockBuilder> builderByLevel = new ArrayList<BlockfileIndexBlockBuilder>();

    public BlockfileIndexer(BlockfileWriterState writerState, int maxRecordsPerLevel, Optional<ByteLength> optTargetBlockSize, BlockfileIndexBlockCodec indexBlockCodec) {
        this.writerState = writerState;
        this.maxRecordsPerLevel = maxRecordsPerLevel;
        this.optTargetBlockSize = optTargetBlockSize;
        this.indexBlockCodec = indexBlockCodec;
        this.getOrInitBuilderForLevel(0);
    }

    public void onValueBlockWrite(long globalBlockId, long valueBlockId, BlockfileRowIdRange rowIdRange, BlockfileRowRange rowRange, BlockfileByteRange byteRange) {
        int indexLevel = 0;
        BlockfileIndexEntry child = new BlockfileIndexEntry(indexLevel, globalBlockId, valueBlockId, BlockfileValueBlockIdRange.singleBlock(valueBlockId), rowIdRange, rowRange, byteRange);
        int estEncodedBytes = this.indexBlockCodec.estEncodedBytes(child);
        this.getOrInitBuilderForLevel(indexLevel).addChild(child, estEncodedBytes);
    }

    public Scanner<BlockfileIndexTokens> drainCompletedBlocks() {
        if (!this.builderByLevel.getFirst().isFull()) {
            return Scanner.empty();
        }
        return this.drain(false);
    }

    public Scanner<BlockfileIndexTokens> drainAllBlocks() {
        return this.drain(true);
    }

    private Scanner<BlockfileIndexTokens> drain(boolean drainAll) {
        return Scanner.iterate((Object)0, level -> level + 1).advanceWhile(level -> level < this.builderByLevel.size()).map(this.builderByLevel::get).advanceWhile(builder -> drainAll || builder.isFull()).map(builder -> {
            BlockfileIndexBlockInput indexBlockInput = builder.build(this.writerState.nextGlobalBlockId(), this.writerState.takeIndexBlockId());
            BlockfileIndexTokens tokens = this.indexBlockCodec.encode(indexBlockInput);
            BlockfileByteRange byteRange = this.writerState.appendIndexBlock(tokens);
            if (this.shouldPromote(indexBlockInput, drainAll)) {
                this.promoteToNextLevel(indexBlockInput, byteRange);
            }
            this.builderByLevel.set(builder.level(), new BlockfileIndexBlockBuilder(this.maxRecordsPerLevel, this.optTargetBlockSize, builder.level()));
            return tokens;
        });
    }

    private boolean shouldPromote(BlockfileIndexBlockInput indexBlockInput, boolean drainAll) {
        if (!drainAll) {
            return true;
        }
        if (indexBlockInput.children().isEmpty()) {
            return false;
        }
        return indexBlockInput.level() < this.builderByLevel.size() - 1;
    }

    private void promoteToNextLevel(BlockfileIndexBlockInput indexBlockInput, BlockfileByteRange byteRange) {
        int parentLevel = indexBlockInput.level() + 1;
        BlockfileIndexEntry child = new BlockfileIndexEntry(parentLevel, indexBlockInput.globalBlockId(), indexBlockInput.indexBlockId(), indexBlockInput.toParentValueBlockIdRange(), indexBlockInput.toParentRowIdRange(), indexBlockInput.toParentRowRange(), byteRange);
        int estEncodedBytes = this.indexBlockCodec.estEncodedBytes(child);
        this.getOrInitBuilderForLevel(parentLevel).addChild(child, estEncodedBytes);
    }

    private BlockfileIndexBlockBuilder getOrInitBuilderForLevel(int level) {
        if (level > this.builderByLevel.size() - 1) {
            BlockfileIndexBlockBuilder builder = new BlockfileIndexBlockBuilder(this.maxRecordsPerLevel, this.optTargetBlockSize, level);
            this.builderByLevel.add(builder);
        }
        return this.builderByLevel.get(level);
    }
}

