/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.storage;

import io.datarouter.bytes.blockfile.io.storage.BlockfileLocation;
import java.util.Arrays;

public record BlockfileSegment(String name, long from, byte[] bytes) {
    public long to() {
        return this.from + (long)this.bytes.length;
    }

    public boolean contains(BlockfileLocation location) {
        return this.from <= location.from() && this.to() >= location.to();
    }

    public byte[] extractBytes(BlockfileLocation location) {
        if (!this.contains(location)) {
            String message = String.format("segment (from=%s, to=%s) does not contain location (from=%s, to=%s)", this.from, this.to(), location.from(), location.to());
            throw new IllegalArgumentException(message);
        }
        long start = location.from() - this.from;
        long end = start + (long)location.length();
        return Arrays.copyOfRange(this.bytes, Math.toIntExact(start), Math.toIntExact(end));
    }
}

