/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.read.query;

import io.datarouter.bytes.blockfile.block.decoded.BlockfileIndexBlock;
import io.datarouter.bytes.blockfile.encoding.indexblock.BlockfileIndexBlockCodec;
import io.datarouter.bytes.blockfile.encoding.valueblock.BlockfileValueBlockCodec;
import io.datarouter.bytes.blockfile.index.BlockfileIndexEntry;
import io.datarouter.bytes.blockfile.io.read.BlockfileReader;
import io.datarouter.bytes.blockfile.row.BlockfileRow;
import java.util.Optional;

public class BlockfileRowKeyReader<T> {
    private final BlockfileReader<T> reader;
    private final BlockfileIndexBlockCodec indexBlockCodec;
    private final BlockfileValueBlockCodec valueBlockCodec;

    public BlockfileRowKeyReader(BlockfileReader<T> reader) {
        this.reader = reader;
        this.indexBlockCodec = reader.metadata().header().indexBlockFormat().supplier().get();
        this.valueBlockCodec = reader.metadata().header().valueBlockFormat().supplier().get();
    }

    public Optional<BlockfileRowKeySearchResult<T>> lastValueBlockSpanningRowKey(byte[] key) {
        BlockfileIndexEntry indexEntry;
        Optional<BlockfileIndexEntry> optIndex;
        BlockfileIndexBlock indexBlock = this.reader.metadata().rootIndex();
        while (indexBlock.level() > 0) {
            optIndex = this.indexBlockCodec.lastChildContainingKey(indexBlock, key);
            if (optIndex.isEmpty()) {
                return Optional.empty();
            }
            indexEntry = optIndex.orElseThrow();
            indexBlock = this.reader.loadIndexBlock(indexEntry);
        }
        optIndex = this.indexBlockCodec.lastChildContainingKey(indexBlock, key);
        if (optIndex.isEmpty()) {
            return Optional.empty();
        }
        indexEntry = optIndex.orElseThrow();
        BlockfileValueBlockCodec.BlockfileEncodedValueBlock encodedValueBlock = this.reader.loadEncodedValueBlock(indexEntry);
        BlockfileRowKeySearchResult result = new BlockfileRowKeySearchResult(encodedValueBlock, indexEntry.childGlobalBlockId(), indexEntry.childIndexOrValueBlockId(), indexEntry.rowIdRange().first());
        return Optional.of(result);
    }

    public Optional<BlockfileRowKeySearchResult<T>> valueBlockContainingRowKey(byte[] key) {
        return this.lastValueBlockSpanningRowKey(key).filter(result -> this.valueBlockCodec.containsKey(result.encodedValueBlock(), key));
    }

    public Optional<BlockfileRow> row(byte[] key) {
        return this.lastValueBlockSpanningRowKey(key).map(BlockfileRowKeySearchResult::encodedValueBlock).flatMap(encodedValueBlock -> this.valueBlockCodec.findLatestVersion((BlockfileValueBlockCodec.BlockfileEncodedValueBlock)encodedValueBlock, key));
    }

    public Optional<T> item(byte[] key) {
        return this.row(key).map(this.reader.config().rowDecoder()::apply);
    }

    public record BlockfileRowKeySearchResult<T>(BlockfileValueBlockCodec.BlockfileEncodedValueBlock encodedValueBlock, long globalBlockId, long valueBlockId, long firstItemId) {
    }
}

