/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.read.query;

import io.datarouter.bytes.blockfile.block.decoded.BlockfileIndexBlock;
import io.datarouter.bytes.blockfile.encoding.indexblock.BlockfileIndexBlockCodec;
import io.datarouter.bytes.blockfile.encoding.valueblock.BlockfileValueBlockCodec;
import io.datarouter.bytes.blockfile.index.BlockfileIndexEntry;
import io.datarouter.bytes.blockfile.io.read.BlockfileReader;
import io.datarouter.bytes.blockfile.row.BlockfileRow;

public class BlockfileRowIdReader<T> {
    private final BlockfileReader<T> reader;
    private final BlockfileIndexBlockCodec indexBlockCodec;
    private final BlockfileValueBlockCodec valueBlockCodec;

    public BlockfileRowIdReader(BlockfileReader<T> reader) {
        this.reader = reader;
        this.indexBlockCodec = reader.metadata().header().indexBlockFormat().supplier().get();
        this.valueBlockCodec = reader.metadata().header().valueBlockFormat().supplier().get();
    }

    public BlockfileRowIdSearchResult<T> valueBlockWithRowId(long rowId) {
        BlockfileIndexEntry indexEntry;
        BlockfileIndexBlock indexBlock = this.reader.metadata().rootIndex();
        while (indexBlock.level() > 0) {
            indexEntry = this.indexBlockCodec.childContainingRowId(indexBlock, rowId);
            indexBlock = this.reader.loadIndexBlock(indexEntry);
        }
        indexEntry = this.indexBlockCodec.childContainingRowId(indexBlock, rowId);
        return new BlockfileRowIdSearchResult(this.reader.loadEncodedValueBlock(indexEntry), indexEntry.childGlobalBlockId(), indexEntry.childIndexOrValueBlockId(), indexEntry.rowIdRange().first());
    }

    public BlockfileRow row(long rowId) {
        BlockfileRowIdSearchResult<T> blockSearchResult = this.valueBlockWithRowId(rowId);
        BlockfileValueBlockCodec.BlockfileEncodedValueBlock encodedValueBlock = blockSearchResult.encodedValueBlock();
        return this.valueBlockCodec.row(encodedValueBlock, rowId);
    }

    public T item(long rowId) {
        BlockfileRow row = this.row(rowId);
        return this.reader.config().rowDecoder().apply(row);
    }

    public record BlockfileRowIdSearchResult<T>(BlockfileValueBlockCodec.BlockfileEncodedValueBlock encodedValueBlock, long globalBlockId, long valueBlockId, long firstItemId) {
    }
}

