/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.read.query;

import io.datarouter.bytes.blockfile.block.decoded.BlockfileIndexBlock;
import io.datarouter.bytes.blockfile.encoding.indexblock.BlockfileIndexBlockCodec;
import io.datarouter.bytes.blockfile.index.BlockfileIndexEntry;
import io.datarouter.bytes.blockfile.index.BlockfileRowIdRange;
import io.datarouter.bytes.blockfile.io.read.BlockfileReader;
import io.datarouter.scanner.ObjectScanner;
import io.datarouter.scanner.Scanner;

public class BlockfileIndexReader<T> {
    private final BlockfileReader<T> reader;
    private final BlockfileIndexBlockCodec indexBlockCodec;

    public BlockfileIndexReader(BlockfileReader<T> reader) {
        this.reader = reader;
        this.indexBlockCodec = reader.metadata().header().indexBlockFormat().supplier().get();
    }

    public Scanner<BlockfileIndexEntry> scanRootIndexEntries() {
        return this.indexBlockCodec.scanChildren(this.reader.metadata().rootIndex());
    }

    public long numRows() {
        return this.scanRootIndexEntries().findLast().map(BlockfileIndexEntry::rowIdRange).map(BlockfileRowIdRange::last).map(i -> i + 1L).orElse(0L);
    }

    public Scanner<BlockfileIndexEntry> scanLeafIndexEntries() {
        return this.indexBlockCodec.scanChildren(this.reader.metadata().rootIndex()).concat(this::scanIndexEntryAndDescendants).include(indexEntry -> indexEntry.level() == 0);
    }

    public Scanner<BlockfileIndexEntry> scanIndexEntries() {
        return this.scanRootIndexEntries().concat(this::scanIndexEntryAndDescendants);
    }

    private Scanner<BlockfileIndexEntry> scanIndexEntryAndDescendants(BlockfileIndexEntry indexEntry) {
        Scanner parent = ObjectScanner.of((Object)indexEntry);
        if (indexEntry.level() == 0) {
            return parent;
        }
        BlockfileIndexBlock childIndexBlock = this.reader.loadIndexBlock(indexEntry);
        Scanner descendants = this.indexBlockCodec.scanChildren(childIndexBlock).concat(this::scanIndexEntryAndDescendants);
        return Scanner.concat((Scanner[])new Scanner[]{parent, descendants});
    }
}

