/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.read.query;

import io.datarouter.bytes.blockfile.block.decoded.BlockfileIndexBlock;
import io.datarouter.bytes.blockfile.encoding.indexblock.BlockfileIndexBlockCodec;
import io.datarouter.bytes.blockfile.encoding.valueblock.BlockfileValueBlockCodec;
import io.datarouter.bytes.blockfile.index.BlockfileIndexEntry;
import io.datarouter.bytes.blockfile.io.read.BlockfileReader;

public class BlockfileBlockIdReader<T> {
    private final BlockfileReader<T> reader;
    private final BlockfileIndexBlockCodec indexBlockCodec;

    public BlockfileBlockIdReader(BlockfileReader<T> reader) {
        this.reader = reader;
        this.indexBlockCodec = reader.metadata().header().indexBlockFormat().supplier().get();
    }

    public BlockfileBlockIdSearchResult<T> valueBlockId(long valueBlockId) {
        BlockfileIndexEntry indexEntry;
        BlockfileIndexBlock indexBlock = this.reader.metadata().rootIndex();
        while (indexBlock.level() > 0) {
            indexEntry = this.indexBlockCodec.childContainingValueBlockId(indexBlock, valueBlockId);
            indexBlock = this.reader.loadIndexBlock(indexEntry);
        }
        indexEntry = this.indexBlockCodec.childContainingValueBlockId(indexBlock, valueBlockId);
        BlockfileValueBlockCodec.BlockfileEncodedValueBlock encodedValueBlock = this.reader.loadEncodedValueBlock(indexEntry);
        return new BlockfileBlockIdSearchResult(encodedValueBlock, indexEntry.childGlobalBlockId(), indexEntry.childIndexOrValueBlockId(), indexEntry.rowIdRange().first());
    }

    public record BlockfileBlockIdSearchResult<T>(BlockfileValueBlockCodec.BlockfileEncodedValueBlock encodedValueBlock, long globalBlockId, long valueBlockId, long firstItemId) {
    }
}

