/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.read.metadata;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.KvString;
import io.datarouter.bytes.blockfile.block.decoded.BlockfileFooterBlock;
import io.datarouter.bytes.blockfile.block.decoded.BlockfileHeaderBlock;
import io.datarouter.bytes.blockfile.block.decoded.BlockfileIndexBlock;
import io.datarouter.bytes.blockfile.block.tokens.BlockfileFooterTokens;
import io.datarouter.bytes.blockfile.block.tokens.BlockfileHeaderTokens;
import io.datarouter.bytes.blockfile.io.read.metadata.BlockfileMetadataCache;
import io.datarouter.bytes.blockfile.io.storage.BlockfileStorage;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockfileMetadataReader<T> {
    private static final Logger logger = LoggerFactory.getLogger(BlockfileMetadataReader.class);
    private static final ByteLength INITIAL_ENDING_FETCH_SIZE = ByteLength.ofKiB(16L);
    private final BlockfileMetadataReaderConfig<T> config;
    private final String name;
    private final BlockfileMetadataCache<Integer> cachedHeaderBlockLength = new BlockfileMetadataCache<Integer>(this::loadHeaderBlockLength);
    private final BlockfileMetadataCache<BlockfileHeaderBlock> cachedHeader = new BlockfileMetadataCache<BlockfileHeaderBlock>(this::loadHeader);
    private final BlockfileMetadataCache<BlockfileIndexBlock> cachedRootIndex = new BlockfileMetadataCache<BlockfileIndexBlock>(this::loadRootIndex);
    private final BlockfileMetadataCache<BlockfileFooterBlock> cachedFooter = new BlockfileMetadataCache<BlockfileFooterBlock>(this::loadFooter);
    private final BlockfileMetadataCache<Integer> cachedFooterBlockLength = new BlockfileMetadataCache<Integer>(this::loadFooterBlockLength);
    private final BlockfileMetadataCache<Long> cachedFileLength = new BlockfileMetadataCache<Long>(this::loadFileLength);

    public BlockfileMetadataReader(BlockfileMetadataReaderConfig<T> config, String name) {
        this.config = config;
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public int headerBlockLength() {
        return this.cachedHeaderBlockLength.get();
    }

    private int loadHeaderBlockLength() {
        this.loadEndOfFile();
        return this.cachedHeaderBlockLength.get();
    }

    public BlockfileHeaderBlock header() {
        return this.cachedHeader.get();
    }

    private BlockfileHeaderBlock loadHeader() {
        this.loadEndOfFile();
        return this.cachedHeader.get();
    }

    public void readAndCacheHeader(InputStream inputStream) {
        int blockLength = BlockfileHeaderTokens.readBlockLength(inputStream);
        this.cachedHeaderBlockLength.set(blockLength);
        BlockfileHeaderTokens.readBlockType(inputStream);
        byte[] valueBytes = BlockfileHeaderTokens.readValueBytes(inputStream, blockLength);
        BlockfileHeaderBlock header = this.config.headerCodec().decode(valueBytes);
        this.cachedHeader.set(header);
    }

    public BlockfileIndexBlock rootIndex() {
        return this.cachedRootIndex.get();
    }

    private BlockfileIndexBlock loadRootIndex() {
        this.loadEndOfFile();
        return this.cachedRootIndex.get();
    }

    public BlockfileFooterBlock footer() {
        return this.cachedFooter.get();
    }

    private BlockfileFooterBlock loadFooter() {
        this.loadEndOfFile();
        return this.cachedFooter.get();
    }

    public int footerBlockLength() {
        return this.cachedFooterBlockLength.get();
    }

    private int loadFooterBlockLength() {
        this.loadEndOfFile();
        return this.cachedFooterBlockLength.get();
    }

    public long fileLength() {
        return this.cachedFileLength.get();
    }

    private long loadFileLength() {
        return this.config.knownFileLength().orElseGet(() -> this.config.storage().length(this.name));
    }

    private void loadEndOfFile() {
        int numBytesToFetch = INITIAL_ENDING_FETCH_SIZE.toBytesInt();
        byte[] endingBytes;
        while (!this.tryLoadEndOfFile(endingBytes = this.config.storage().readEnding(this.name, numBytesToFetch))) {
            if (endingBytes.length < numBytesToFetch) {
                String message = String.format("Failed to load footer after reading entire file %s", new KvString().add("name", this.name).add("bytesFetched", numBytesToFetch, Object::toString));
                throw new RuntimeException(message);
            }
            logger.warn("incomplete end of file", (Object)new KvString().add("name", this.name).add("bytesFetched", numBytesToFetch, Object::toString));
            numBytesToFetch *= 2;
        }
        return;
    }

    private boolean tryLoadEndOfFile(byte[] endingBytes) {
        int footerBlockLength = BlockfileFooterTokens.decodeFooterBlockLengthFromEndOfFileBytes(endingBytes);
        this.cachedFooterBlockLength.set(footerBlockLength);
        if (footerBlockLength > endingBytes.length) {
            return false;
        }
        byte[] footerValueBytes = BlockfileFooterTokens.decodeFooterValueBytesFromEndOfFileBytes(endingBytes);
        BlockfileFooterBlock footer = BlockfileFooterBlock.VALUE_CODEC.decode(footerValueBytes);
        this.cachedFooter.set(footer);
        this.cachedHeaderBlockLength.set(footer.headerBlockLocation().length());
        this.cachedHeader.set(this.config.headerCodec().decode(footer.headerBytes().bytes()));
        int rootIndexOffsetFromEnd = footerBlockLength + footer.rootIndexBlockLocation().length();
        if (rootIndexOffsetFromEnd > endingBytes.length) {
            return false;
        }
        byte[] rootIndexBytes = Arrays.copyOfRange(endingBytes, endingBytes.length - rootIndexOffsetFromEnd, endingBytes.length - footerBlockLength);
        BlockfileIndexBlock rootIndex = this.header().indexBlockFormat().supplier().get().decode(rootIndexBytes);
        this.cachedRootIndex.set(rootIndex);
        return true;
    }

    public record BlockfileMetadataReaderConfig<T>(BlockfileStorage storage, BlockfileHeaderBlock.BlockfileHeaderCodec headerCodec, Optional<Long> knownFileLength) {
    }
}

