/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.io.compact;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.blockfile.io.merge.BlockfileMergePlan;
import io.datarouter.bytes.blockfile.io.storage.BlockfileNameAndSize;
import io.datarouter.bytes.blockfile.row.BlockfileRowCollator;
import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;

public class BlockfileCompactorFileCache {
    private final int targetNumFiles;
    private final boolean prune;
    private final ByteLength readBufferSize;
    private final int memoryFanIn;
    private final int streamingFanIn;
    private final SortedSet<BlockfileNameAndSize> files;

    public BlockfileCompactorFileCache(int targetNumFiles, boolean prune, ByteLength readBufferSize, int memoryFanIn, int streamingFanIn, List<BlockfileNameAndSize> files) {
        this.targetNumFiles = targetNumFiles;
        this.prune = prune;
        this.readBufferSize = readBufferSize;
        this.memoryFanIn = memoryFanIn;
        this.streamingFanIn = streamingFanIn;
        this.files = new TreeSet<BlockfileNameAndSize>(BlockfileNameAndSize.COMPARE_SIZE_AND_NAME);
        this.files.addAll(files);
        if (this.files.size() != files.size()) {
            String message = String.format("%s != %s", this.files.size(), files.size());
            throw new RuntimeException(message);
        }
    }

    public int numFiles() {
        return this.files.size();
    }

    public ByteLength totalSize() {
        return BlockfileNameAndSize.totalSize(this.files);
    }

    public void add(BlockfileNameAndSize file) {
        this.files.add(file);
    }

    public void remove(BlockfileNameAndSize file) {
        this.files.remove(file);
    }

    public boolean hasMoreToMerge() {
        return this.files.size() > this.targetNumFiles;
    }

    public Optional<BlockfileMergePlan> findNextMergePlan() {
        if (!this.hasMoreToMerge()) {
            return Optional.empty();
        }
        Map<Integer, FilesAtLevel> filesByLevel = this.splitFilesByLevel();
        TreeSet<BlockfileNameAndSize> candidates = new TreeSet<BlockfileNameAndSize>(BlockfileNameAndSize.COMPARE_SIZE_AND_NAME);
        ArrayList<Integer> candidateLevels = new ArrayList<Integer>();
        FilesAtLevel lowerLevel = (FilesAtLevel)Scanner.of(filesByLevel.values()).findFirst().orElseThrow();
        candidates.addAll(lowerLevel.files());
        candidateLevels.add(lowerLevel.level());
        if (candidates.size() == 1 && filesByLevel.size() > 1) {
            FilesAtLevel upperLevel = (FilesAtLevel)Scanner.of(filesByLevel.values()).skip(1L).findFirst().orElseThrow();
            candidates.addAll(upperLevel.files());
            candidateLevels.add(upperLevel.level());
        }
        List<BlockfileNameAndSize> toMerge = this.chooseFiles(candidates);
        int numRemainingFiles = this.files.size() - toMerge.size() + 1;
        BlockfileRowCollator.BlockfileRowCollatorStrategy collatorStrategy = BlockfileRowCollator.BlockfileRowCollatorStrategy.KEEP_ALL;
        if (this.prune && numRemainingFiles == 1) {
            collatorStrategy = BlockfileRowCollator.BlockfileRowCollatorStrategy.PRUNE_ALL;
        }
        BlockfileMergePlan mergePlan = new BlockfileMergePlan(this.files.size(), BlockfileNameAndSize.totalSize(this.files), candidateLevels, toMerge, collatorStrategy);
        return Optional.of(mergePlan);
    }

    private List<BlockfileNameAndSize> chooseFiles(Set<BlockfileNameAndSize> candidates) {
        int remainingToMergeAllLevels = this.files.size() - this.targetNumFiles + 1;
        int maxMemoryFiles = Math.min(remainingToMergeAllLevels, this.memoryFanIn);
        SizeLimiter sizeLimiter = new SizeLimiter(this.readBufferSize);
        List toMergeMemory = Scanner.of(candidates).limit((long)maxMemoryFiles).advanceWhile(sizeLimiter::fits).each(sizeLimiter::add).list();
        int maxStreamingFiles = Math.min(remainingToMergeAllLevels, this.streamingFanIn);
        List toMergeStreaming = Scanner.of(candidates).limit((long)maxStreamingFiles).list();
        return toMergeMemory.size() > toMergeStreaming.size() ? toMergeMemory : toMergeStreaming;
    }

    private Map<Integer, FilesAtLevel> splitFilesByLevel() {
        Map grouped = Scanner.of(this.files).groupBy(file -> BlockfileCompactorFileCache.level(file.size()));
        return Scanner.of(grouped.entrySet()).toMapSupplied(Map.Entry::getKey, kv -> (FilesAtLevel)Scanner.of((Iterable)((Iterable)kv.getValue())).sort(BlockfileNameAndSize.COMPARE_SIZE_AND_NAME).listTo(files -> new FilesAtLevel((Integer)kv.getKey(), (List<BlockfileNameAndSize>)files)), TreeMap::new);
    }

    public static int level(long fileSize) {
        if (fileSize == 0L || fileSize == 1L) {
            return 0;
        }
        long highestOneBit = Long.highestOneBit(fileSize - 1L);
        return 1 + Long.numberOfTrailingZeros(highestOneBit);
    }

    private record FilesAtLevel(int level, List<BlockfileNameAndSize> files) {
    }

    private static class SizeLimiter {
        ByteLength maxSize;
        AtomicLong currentSize = new AtomicLong();

        SizeLimiter(ByteLength maxSize) {
            this.maxSize = maxSize;
            this.currentSize = new AtomicLong();
        }

        boolean fits(BlockfileNameAndSize file) {
            return this.currentSize.get() + file.size() <= this.maxSize.toBytes();
        }

        void add(BlockfileNameAndSize file) {
            this.currentSize.addAndGet(file.size());
        }
    }
}

