/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.index;

import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockfileRangeSearchTool {
    private static final Logger logger = LoggerFactory.getLogger(BlockfileRangeSearchTool.class);

    public static <C, I> int startIndex(int size, Function<Integer, I> extractFn, Function<I, Integer> compareFn) {
        int low = 0;
        int high = size - 1;
        int mid = 0;
        int comp = 0;
        while (low <= high) {
            mid = low + (high - low) / 2;
            comp = compareFn.apply(extractFn.apply(mid));
            if (comp < 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        comp = compareFn.apply(extractFn.apply(mid));
        if (comp < 0) {
            return mid + 1;
        }
        if (comp == 0) {
            return mid;
        }
        return mid == 0 ? -1 : mid;
    }

    public static <C, I> int endIndex(int size, Function<Integer, I> extractFn, Function<I, Integer> compareFn) {
        int low = 0;
        int high = size - 1;
        int mid = 0;
        int comp = 0;
        while (low <= high) {
            mid = low + (high - low) / 2;
            comp = compareFn.apply(extractFn.apply(mid));
            if (comp <= 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        comp = compareFn.apply(extractFn.apply(mid));
        if (comp <= 0) {
            return mid;
        }
        return mid - 1;
    }
}

