/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.encoding.valueblock.impl;

import io.datarouter.bytes.blockfile.encoding.valueblock.BlockfileValueBlockCodec;
import io.datarouter.bytes.blockfile.io.read.query.BlockfileRowKeyRangeReader;
import io.datarouter.bytes.blockfile.row.BlockfileRow;
import io.datarouter.bytes.blockfile.row.BlockfileRowCodec;
import io.datarouter.bytes.blockfile.row.BlockfileRowOp;
import io.datarouter.bytes.varint.VarIntTool;
import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class BlockfileSequentialValueBlockCodec
implements BlockfileValueBlockCodec {
    @Override
    public BlockfileValueBlockCodec.BlockfileEncodedValueBlock encode(BlockfileValueBlockCodec.BlockfileValueBlockRows input) {
        int numHeaderBytes = VarIntTool.length(input.valueBlockId()) + VarIntTool.length(input.firstRowIdInBlock()) + VarIntTool.length(input.rows().size());
        int numDataBytes = 0;
        for (BlockfileRow row : input.rows()) {
            numDataBytes += row.length();
        }
        int numBytes = numHeaderBytes + numDataBytes;
        byte[] bytes = new byte[numBytes];
        int cursor = 0;
        cursor += VarIntTool.encode(bytes, cursor, input.valueBlockId());
        cursor += VarIntTool.encode(bytes, cursor, input.firstRowIdInBlock());
        cursor += VarIntTool.encode(bytes, cursor, input.rows().size());
        for (BlockfileRow row : input.rows()) {
            System.arraycopy(row.backingBytes(), row.offset(), bytes, cursor, row.length());
            cursor += row.length();
        }
        return new BlockfileValueBlockCodec.BlockfileEncodedValueBlock(bytes);
    }

    @Override
    public BlockfileValueBlockCodec.BlockfileValueBlockRows decode(BlockfileValueBlockCodec.BlockfileEncodedValueBlock encodedBlock, BlockfileRowKeyRangeReader.BlockfileKeyRange keyRange) {
        byte[] bytes = encodedBlock.bytes();
        Prefix prefix = Prefix.decode(bytes);
        int cursor = prefix.length();
        ArrayList<BlockfileRow> rows = new ArrayList<BlockfileRow>(prefix.numRows());
        if (keyRange.isEverything()) {
            int i = 0;
            while (i < prefix.numRows()) {
                BlockfileRow row = BlockfileRowCodec.fromBytes(bytes, cursor);
                cursor += row.length();
                rows.add(row);
                ++i;
            }
        } else {
            int i = 0;
            while (i < prefix.numRows()) {
                BlockfileRow row = BlockfileRowCodec.fromBytes(bytes, cursor);
                cursor += row.length();
                if (keyRange.contains(row)) {
                    rows.add(row);
                }
                ++i;
            }
        }
        return new BlockfileValueBlockCodec.BlockfileValueBlockRows(prefix.valueBlockId(), prefix.firstRowIdInBlock(), rows);
    }

    @Override
    public Scanner<BlockfileRow> scanAllVersions(BlockfileValueBlockCodec.BlockfileEncodedValueBlock encodedBlock, byte[] key) {
        byte[] bytes = encodedBlock.bytes();
        Prefix prefix = Prefix.decode(bytes);
        AtomicInteger cursor = new AtomicInteger(prefix.length);
        while (cursor.get() < bytes.length) {
            BlockfileRow row2 = BlockfileRowCodec.fromBytes(bytes, cursor.get());
            if (row2.compareToKey(key) >= 0) break;
            cursor.addAndGet(row2.length());
        }
        Supplier<BlockfileRow> nextRowSupplier = () -> {
            if (cursor.get() == bytes.length) {
                return null;
            }
            BlockfileRow row = BlockfileRowCodec.fromBytes(bytes, cursor.get());
            cursor.addAndGet(row.length());
            return row.equalsKey(key) ? row : null;
        };
        return Scanner.generate(nextRowSupplier).advanceWhile(row -> row != null);
    }

    @Override
    public Optional<BlockfileRow> findLatestVersion(BlockfileValueBlockCodec.BlockfileEncodedValueBlock encodedBlock, byte[] key) {
        return this.scanAllVersions(encodedBlock, key).findLast().filter(row -> row.op() == BlockfileRowOp.PUT);
    }

    private record Prefix(long valueBlockId, long firstRowIdInBlock, int numRows, int length) {
        static Prefix decode(byte[] bytes) {
            int cursor = 0;
            long valueBlockId = VarIntTool.decodeLong(bytes, cursor);
            long firstRowId = VarIntTool.decodeLong(bytes, cursor += VarIntTool.length(valueBlockId));
            int numRows = VarIntTool.decodeInt(bytes, cursor += VarIntTool.length(firstRowId));
            return new Prefix(valueBlockId, firstRowId, numRows, cursor += VarIntTool.length(numRows));
        }
    }
}

