/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.encoding.indexblock;

import io.datarouter.bytes.blockfile.block.decoded.BlockfileIndexBlock;
import io.datarouter.bytes.blockfile.block.tokens.BlockfileIndexTokens;
import io.datarouter.bytes.blockfile.index.BlockfileIndexBlockInput;
import io.datarouter.bytes.blockfile.index.BlockfileIndexEntry;
import io.datarouter.bytes.blockfile.index.BlockfilePointSearchTool;
import io.datarouter.bytes.blockfile.index.BlockfileRangeSearchTool;
import io.datarouter.scanner.Scanner;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface BlockfileIndexBlockCodec {
    public static final Logger logger = LoggerFactory.getLogger(BlockfileIndexBlockCodec.class);

    public BlockfileIndexTokens encode(BlockfileIndexBlockInput var1);

    public BlockfileIndexBlock decode(byte[] var1);

    public int estEncodedBytes(BlockfileIndexEntry var1);

    public BlockfileIndexEntry decodeChild(BlockfileIndexBlock var1, int var2);

    default public BlockfileIndexEntry firstChild(BlockfileIndexBlock block) {
        return this.decodeChild(block, 0);
    }

    default public BlockfileIndexEntry lastChild(BlockfileIndexBlock block) {
        return this.decodeChild(block, block.numChildren() - 1);
    }

    default public Scanner<BlockfileIndexEntry> scanChildren(BlockfileIndexBlock block) {
        return Scanner.iterate((Object)0, i -> i + 1).limit((long)block.numChildren()).map(i -> this.decodeChild(block, (int)i));
    }

    default public Scanner<BlockfileIndexEntry> scanChildrenDesc(BlockfileIndexBlock block) {
        return Scanner.iterate((Object)(block.numChildren() - 1), i -> i - 1).limit((long)block.numChildren()).map(i -> this.decodeChild(block, (int)i));
    }

    default public BlockfileIndexEntry childContainingValueBlockId(BlockfileIndexBlock block, long valueBlockId) {
        return BlockfilePointSearchTool.findAny(block.numChildren(), childIndex -> this.decodeChild(block, (int)childIndex), indexEntry -> indexEntry.valueBlockIdRange().compareTo(valueBlockId)).orElseThrow();
    }

    default public BlockfileIndexEntry childContainingRowId(BlockfileIndexBlock block, long rowId) {
        return BlockfilePointSearchTool.findAny(block.numChildren(), childIndex -> this.decodeChild(block, (int)childIndex), indexEntry -> indexEntry.rowIdRange().compareTo(rowId)).orElseThrow();
    }

    default public Optional<BlockfileIndexEntry> firstChildContainingKey(BlockfileIndexBlock block, byte[] key) {
        return BlockfilePointSearchTool.findFirst(block.numChildren(), childIndex -> this.decodeChild(block, (int)childIndex), indexEntry -> indexEntry.rowRange().compareToKey(key));
    }

    default public Optional<BlockfileIndexEntry> lastChildContainingKey(BlockfileIndexBlock block, byte[] key) {
        return BlockfilePointSearchTool.findLast(block.numChildren(), childIndex -> this.decodeChild(block, (int)childIndex), indexEntry -> indexEntry.rowRange().compareToKey(key));
    }

    default public int rangeStartIndex(BlockfileIndexBlock block, byte[] key) {
        int index = BlockfileRangeSearchTool.startIndex(block.numChildren(), childIndex -> this.decodeChild(block, (int)childIndex), indexEntry -> indexEntry.rowRange().compareToKey(key));
        return Math.max(0, index);
    }

    default public int rangeEndIndex(BlockfileIndexBlock block, byte[] key) {
        return BlockfileRangeSearchTool.endIndex(block.numChildren(), childIndex -> this.decodeChild(block, (int)childIndex), indexEntry -> indexEntry.rowRange().compareToKey(key));
    }
}

