/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.block.tokens;

import io.datarouter.bytes.blockfile.block.BlockfileBlockType;
import io.datarouter.bytes.blockfile.block.tokens.BlockfileBaseTokens;
import io.datarouter.bytes.blockfile.io.storage.BlockfileLocation;
import io.datarouter.bytes.io.InputStreamTool;
import java.io.InputStream;
import java.util.List;

public class BlockfileHeaderTokens
extends BlockfileBaseTokens {
    private final byte[] value;

    public BlockfileHeaderTokens(int length, byte[] value) {
        super(length, BlockfileBlockType.HEADER);
        this.value = value;
    }

    @Override
    public int suffixLength() {
        return this.value.length;
    }

    @Override
    public List<byte[]> toList() {
        return List.of(this.prefixBytes(), this.value);
    }

    public static BlockfileLocation lengthLocation() {
        return new BlockfileLocation(0L, BlockfileBaseTokens.NUM_LENGTH_BYTES);
    }

    public static long valueOffset() {
        return BlockfileBaseTokens.NUM_PREFIX_BYTES;
    }

    public static int valueLength(int blockLength) {
        return blockLength - BlockfileBaseTokens.NUM_PREFIX_BYTES;
    }

    public static BlockfileLocation valueLocation(int blockLength) {
        return new BlockfileLocation(BlockfileHeaderTokens.valueOffset(), BlockfileHeaderTokens.valueLength(blockLength));
    }

    public static int readBlockLength(InputStream inputStream) {
        byte[] blockLengthBytes = InputStreamTool.readNBytes(inputStream, NUM_LENGTH_BYTES);
        return BlockfileHeaderTokens.decodeLength(blockLengthBytes);
    }

    public static BlockfileBlockType readBlockType(InputStream inputStream) {
        byte blockTypeByte = InputStreamTool.readRequiredByte(inputStream);
        return BlockfileBlockType.decode(blockTypeByte);
    }

    public static byte[] readValueBytes(InputStream inputStream, int blockLength) {
        int valueLength = BlockfileHeaderTokens.valueLength(blockLength);
        return InputStreamTool.readNBytes(inputStream, valueLength);
    }
}

