/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.block.tokens;

import io.datarouter.bytes.blockfile.block.BlockfileBlockType;
import io.datarouter.bytes.blockfile.block.tokens.BlockfileBaseTokens;
import io.datarouter.bytes.blockfile.io.storage.BlockfileLocation;
import java.util.Arrays;
import java.util.List;

public class BlockfileFooterTokens
extends BlockfileBaseTokens {
    private final byte[] value;

    public BlockfileFooterTokens(int length, byte[] value) {
        super(length, BlockfileBlockType.FOOTER);
        this.value = value;
    }

    @Override
    public int suffixLength() {
        return this.value.length + NUM_LENGTH_BYTES;
    }

    @Override
    public List<byte[]> toList() {
        return List.of(this.prefixBytes(), this.value, this.encodeLength());
    }

    public static BlockfileLocation lengthLocation(long fileLength) {
        return new BlockfileLocation(fileLength - (long)NUM_LENGTH_BYTES, NUM_LENGTH_BYTES);
    }

    public static BlockfileLocation blockLocation(long fileLength, int footerBlockLength) {
        return new BlockfileLocation(fileLength - (long)footerBlockLength, footerBlockLength);
    }

    public static BlockfileLocation valueLocation(long fileLength, int footerBlockLength) {
        BlockfileLocation blockLocation = BlockfileFooterTokens.blockLocation(fileLength, footerBlockLength);
        return BlockfileFooterTokens.valueLocation(blockLocation);
    }

    public static BlockfileLocation valueLocation(BlockfileLocation blockLocation) {
        long from = blockLocation.from() + (long)NUM_PREFIX_BYTES;
        int length = blockLocation.length() - NUM_PREFIX_BYTES - NUM_LENGTH_BYTES;
        return new BlockfileLocation(from, length);
    }

    public static int decodeFooterBlockLengthFromEndOfFileBytes(byte[] endOfFileBytes) {
        int from = endOfFileBytes.length - NUM_LENGTH_BYTES;
        int to = endOfFileBytes.length;
        byte[] lengthBytes = Arrays.copyOfRange(endOfFileBytes, from, to);
        return BlockfileFooterTokens.decodeLength(lengthBytes);
    }

    public static byte[] decodeFooterValueBytesFromEndOfFileBytes(byte[] endOfFileBytes) {
        int footerBlockLength = BlockfileFooterTokens.decodeFooterBlockLengthFromEndOfFileBytes(endOfFileBytes);
        int from = endOfFileBytes.length - footerBlockLength + NUM_PREFIX_BYTES;
        int to = endOfFileBytes.length - NUM_LENGTH_BYTES;
        return Arrays.copyOfRange(endOfFileBytes, from, to);
    }
}

