/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.block.decoded;

import io.datarouter.bytes.BinaryDictionary;
import io.datarouter.bytes.Codec;
import io.datarouter.bytes.RecordByteArrayField;
import io.datarouter.bytes.blockfile.block.BlockfileFooterKey;
import io.datarouter.bytes.blockfile.io.storage.BlockfileLocation;
import io.datarouter.bytes.varint.VarIntTool;

public record BlockfileFooterBlock(RecordByteArrayField headerBytes, BinaryDictionary userDictionary, BlockfileLocation headerBlockLocation, BlockfileLocation rootIndexBlockLocation, long numValueBlocks, long numIndexBlocks) {
    public static final Codec<BlockfileFooterBlock, byte[]> VALUE_CODEC = Codec.of(footer -> footer.toBinaryDictionary().encode(), bytes -> {
        BinaryDictionary dictionary = BinaryDictionary.decode(bytes);
        return new BlockfileFooterBlock(BlockfileFooterBlock.parseHeaderBytes(dictionary), BlockfileFooterBlock.parseUserDictionary(dictionary), BlockfileFooterBlock.parseHeaderBlockLocation(dictionary), BlockfileFooterBlock.parseRootIndexBlockLocation(dictionary), BlockfileFooterBlock.parseNumValueBlocks(dictionary), BlockfileFooterBlock.parseNumIndexBlocks(dictionary));
    });

    private BinaryDictionary toBinaryDictionary() {
        return new BinaryDictionary().put(BlockfileFooterKey.HEADER.bytes, this.headerBytes.bytes()).put(BlockfileFooterKey.USER_DICTIONARY.bytes, this.userDictionary.encode()).put(BlockfileFooterKey.HEADER_BLOCK_LOCATION.bytes, BlockfileLocation.CODEC.encode(this.headerBlockLocation)).put(BlockfileFooterKey.ROOT_INDEX_BLOCK_LOCATION.bytes, BlockfileLocation.CODEC.encode(this.rootIndexBlockLocation)).put(BlockfileFooterKey.NUM_VALUE_BLOCKS.bytes, VarIntTool.encode(this.numValueBlocks)).put(BlockfileFooterKey.NUM_INDEX_BLOCKS.bytes, VarIntTool.encode(this.numIndexBlocks));
    }

    private static RecordByteArrayField parseHeaderBytes(BinaryDictionary dictionary) {
        byte[] bytes = dictionary.get(BlockfileFooterKey.HEADER.bytes);
        return new RecordByteArrayField(bytes);
    }

    private static BinaryDictionary parseUserDictionary(BinaryDictionary dictionary) {
        byte[] bytes = dictionary.get(BlockfileFooterKey.USER_DICTIONARY.bytes);
        return BinaryDictionary.decode(bytes);
    }

    private static BlockfileLocation parseHeaderBlockLocation(BinaryDictionary dictionary) {
        byte[] bytes = dictionary.get(BlockfileFooterKey.HEADER_BLOCK_LOCATION.bytes);
        return BlockfileLocation.CODEC.decode(bytes);
    }

    private static BlockfileLocation parseRootIndexBlockLocation(BinaryDictionary dictionary) {
        byte[] bytes = dictionary.get(BlockfileFooterKey.ROOT_INDEX_BLOCK_LOCATION.bytes);
        return BlockfileLocation.CODEC.decode(bytes);
    }

    private static long parseNumValueBlocks(BinaryDictionary dictionary) {
        byte[] bytes = dictionary.get(BlockfileFooterKey.NUM_VALUE_BLOCKS.bytes);
        return VarIntTool.decodeLong(bytes);
    }

    private static long parseNumIndexBlocks(BinaryDictionary dictionary) {
        byte[] bytes = dictionary.get(BlockfileFooterKey.NUM_INDEX_BLOCKS.bytes);
        return VarIntTool.decodeLong(bytes);
    }
}

