/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.block;

public enum BlockfileBlockType {
    HEADER('H'),
    VALUE('V'),
    INDEX('I'),
    FOOTER('F');

    public static final int NUM_BYTES = 1;
    public final char code;
    public final byte codeByte;
    public final byte[] codeBytes;

    private BlockfileBlockType(char code) {
        this.code = code;
        this.codeByte = (byte)code;
        this.codeBytes = new byte[]{this.codeByte};
    }

    public static BlockfileBlockType decode(byte codeByte) {
        return BlockfileBlockType.decode((char)codeByte);
    }

    public static BlockfileBlockType decode(char code) {
        return switch (code) {
            case 'H' -> HEADER;
            case 'V' -> VALUE;
            case 'I' -> INDEX;
            case 'F' -> FOOTER;
            default -> throw new IllegalArgumentException(String.format("unknown code=%s", Character.valueOf(code)));
        };
    }
}

