/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class KvString {
    private final List<Kv<?>> kvs = new ArrayList();

    public <T> KvString addLazy(String name, Supplier<T> valueSupplier, Function<T, String> toStringFn) {
        this.kvs.add(new Kv<T>(name, valueSupplier, toStringFn));
        return this;
    }

    public KvString addLazy(String name, Supplier<String> value) {
        return this.addLazy(name, value, Function.identity());
    }

    public <T> KvString add(String name, T value, Function<T, String> toStringFn) {
        return this.addLazy(name, () -> value, toStringFn);
    }

    public KvString add(String name, String value) {
        return this.addLazy(name, () -> value);
    }

    public String toString() {
        return this.kvs.stream().map(Kv::toString).collect(Collectors.joining(", "));
    }

    private record Kv<T>(String key, Supplier<T> valueSupplier, Function<T, String> toStringFn) {
        @Override
        public String toString() {
            T value = this.valueSupplier.get();
            String stringValue = value == null ? "" : this.toStringFn.apply(value);
            return String.join((CharSequence)"=", this.key, stringValue);
        }
    }
}

