/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.Codec;
import io.datarouter.bytes.codec.bytestringcodec.HexByteStringCodec;
import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.bytes.varint.VarIntTool;
import io.datarouter.scanner.ObjectScanner;
import io.datarouter.scanner.Scanner;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class BinaryDictionary {
    public static final Codec<BinaryDictionary, byte[]> CODEC = Codec.of(BinaryDictionary::encode, BinaryDictionary::decode);
    private final SortedMap<byte[], byte[]> dictionary = new TreeMap<byte[], byte[]>(Arrays::compareUnsigned);

    public BinaryDictionary put(byte[] key, byte[] value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        if (this.dictionary.containsKey(key)) {
            String message = String.format("cannot overwrite existing key=%s and value=%s", HexByteStringCodec.INSTANCE.encode(key), HexByteStringCodec.INSTANCE.encode(value));
            throw new IllegalArgumentException(message);
        }
        this.dictionary.put(key, value);
        return this;
    }

    public BinaryDictionary put(String key, byte[] value) {
        return this.put(StringCodec.UTF_8.encode(key), value);
    }

    public BinaryDictionary put(String key, String value) {
        return this.put(StringCodec.UTF_8.encode(key), StringCodec.UTF_8.encode(value));
    }

    public int size() {
        return this.dictionary.size();
    }

    public byte[] get(byte[] key) {
        return (byte[])this.dictionary.get(key);
    }

    public byte[] get(String key) {
        return (byte[])this.dictionary.get(StringCodec.UTF_8.encode(key));
    }

    public Optional<byte[]> find(byte[] key) {
        return Optional.ofNullable(this.get(key));
    }

    public Optional<byte[]> find(String key) {
        return Optional.ofNullable(this.get(key));
    }

    public Optional<String> findStringValue(String key) {
        return this.find(key).map(StringCodec.UTF_8::decode);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void that;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BinaryDictionary)) {
            return false;
        }
        BinaryDictionary binaryDictionary = (BinaryDictionary)obj;
        if (this.size() != that.size()) {
            return false;
        }
        Iterator<Map.Entry<byte[], byte[]>> thisKvs = this.dictionary.entrySet().iterator();
        Iterator<Map.Entry<byte[], byte[]>> thatKvs = that.dictionary.entrySet().iterator();
        while (thisKvs.hasNext()) {
            Map.Entry<byte[], byte[]> thisKv = thisKvs.next();
            Map.Entry<byte[], byte[]> thatKv = thatKvs.next();
            if (Arrays.equals(thisKv.getKey(), thatKv.getKey()) && Arrays.equals(thisKv.getValue(), thatKv.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 1;
        for (Map.Entry<byte[], byte[]> kv : this.dictionary.entrySet()) {
            hash += 31 * hash + Arrays.hashCode(kv.getKey());
            hash += 31 * hash + Arrays.hashCode(kv.getValue());
        }
        return hash;
    }

    public int encodedLength() {
        int length = VarIntTool.length(this.dictionary.size());
        for (Map.Entry<byte[], byte[]> kv : this.dictionary.entrySet()) {
            length += VarIntTool.length(kv.getKey().length);
            length += kv.getKey().length;
            length += VarIntTool.length(kv.getValue().length);
            length += kv.getValue().length;
        }
        return length;
    }

    public byte[] encode() {
        return (byte[])ObjectScanner.of((Object)VarIntTool.encode(this.dictionary.size())).append(Scanner.of(this.dictionary.entrySet()).concat(kv -> Scanner.of((Object[])new byte[][]{VarIntTool.encode(((byte[])kv.getKey()).length), (byte[])kv.getKey(), VarIntTool.encode(((byte[])kv.getValue()).length), (byte[])kv.getValue()}))).listTo(ByteTool::concat);
    }

    public static BinaryDictionary decode(byte[] bytes) {
        BinaryDictionary blockfileDictionary = new BinaryDictionary();
        int cursor = 0;
        int numEntries = VarIntTool.decodeInt(bytes, cursor);
        cursor += VarIntTool.length(numEntries);
        int i = 0;
        while (i < numEntries) {
            int keyLength = VarIntTool.decodeInt(bytes, cursor);
            byte[] key = Arrays.copyOfRange(bytes, cursor += VarIntTool.length(keyLength), cursor + keyLength);
            int valueLength = VarIntTool.decodeInt(bytes, cursor += keyLength);
            byte[] value = Arrays.copyOfRange(bytes, cursor += VarIntTool.length(valueLength), cursor + valueLength);
            cursor += valueLength;
            blockfileDictionary.put(key, value);
            ++i;
        }
        return blockfileDictionary;
    }

    public String toStringStringKeysAndHexValues() {
        return (String)Scanner.of(this.dictionary.entrySet()).map(entry -> String.format("%s=%s", StringCodec.UTF_8.decode((byte[])entry.getKey()), HexByteStringCodec.INSTANCE.encode((byte[])entry.getValue()))).collect(Collectors.joining(", "));
    }
}

