/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.read;

import io.datarouter.bytes.kvfile.kv.KvFileEntry;
import io.datarouter.bytes.kvfile.kv.KvFileOp;
import io.datarouter.scanner.BaseLinkedScanner;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.function.Function;

public class KvFileCollator {
    public static Scanner<KvFileEntry> keepAll(List<Scanner<KvFileEntry>> readers) {
        return Scanner.of(readers).collateV2(Function.identity(), KvFileEntry::compareKeyVersionOpOptimized);
    }

    public static Scanner<KvFileEntry> pruneVersions(List<Scanner<KvFileEntry>> readers) {
        return Scanner.of(readers).collateV2(Function.identity(), KvFileEntry::compareKeyVersionOpOptimized).link(KvFileCollatorPruneVersionsScanner::new);
    }

    public static Scanner<KvFileEntry> pruneAll(List<Scanner<KvFileEntry>> readers) {
        return Scanner.of(readers).collateV2(Function.identity(), KvFileEntry::compareKeyVersionOpOptimized).link(KvFileCollatorPruneDeletesScanner::new);
    }

    public static class KvFileCollatorPruneDeletesScanner
    extends BaseLinkedScanner<KvFileEntry, KvFileEntry> {
        private KvFileEntry peeked;

        public KvFileCollatorPruneDeletesScanner(Scanner<KvFileEntry> input) {
            super(input);
        }

        public boolean advanceInternal() {
            this.current = this.peeked;
            this.peeked = null;
            if (this.current == null && this.input.advance()) {
                this.current = (KvFileEntry)this.input.current();
            }
            while (this.input.advance()) {
                if (KvFileEntry.equalsKeyOptimized((KvFileEntry)this.current, (KvFileEntry)this.input.current())) {
                    this.current = (KvFileEntry)this.input.current();
                    continue;
                }
                if (((KvFileEntry)this.current).op() == KvFileOp.DELETE) {
                    this.current = (KvFileEntry)this.input.current();
                    continue;
                }
                this.peeked = (KvFileEntry)this.input.current();
                return true;
            }
            return this.current != null && ((KvFileEntry)this.current).op() != KvFileOp.DELETE;
        }
    }

    public static class KvFileCollatorPruneVersionsScanner
    extends BaseLinkedScanner<KvFileEntry, KvFileEntry> {
        private KvFileEntry peeked;

        public KvFileCollatorPruneVersionsScanner(Scanner<KvFileEntry> input) {
            super(input);
        }

        public boolean advanceInternal() {
            this.current = this.peeked;
            this.peeked = null;
            if (this.current == null && this.input.advance()) {
                this.current = (KvFileEntry)this.input.current();
            }
            while (this.input.advance()) {
                if (KvFileEntry.equalsKeyOptimized((KvFileEntry)this.current, (KvFileEntry)this.input.current())) {
                    this.current = (KvFileEntry)this.input.current();
                    continue;
                }
                this.peeked = (KvFileEntry)this.input.current();
                return true;
            }
            return this.current != null;
        }
    }

    public static enum KvFileCollatorStrategy {
        KEEP_ALL(KvFileCollator::keepAll),
        PRUNE_VERSIONS(KvFileCollator::pruneVersions),
        PRUNE_ALL(KvFileCollator::pruneAll);

        public final Function<List<Scanner<KvFileEntry>>, Scanner<KvFileEntry>> method;

        private KvFileCollatorStrategy(Function<List<Scanner<KvFileEntry>>, Scanner<KvFileEntry>> method) {
            this.method = method;
        }
    }
}

