/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.io.header;

import io.datarouter.bytes.BinaryDictionary;
import io.datarouter.bytes.Codec;
import io.datarouter.bytes.codec.stringcodec.StringCodec;
import io.datarouter.bytes.kvfile.io.header.KvFileHeaderKey;
import java.util.List;

public record KvFileHeader(BinaryDictionary userDictionary, String blockFormat) {
    public static final String BLOCK_FORMAT_PLACEHOLDER = "SEQUENTIAL";

    public BinaryDictionary toBinaryDictionary() {
        return new BinaryDictionary().put(KvFileHeaderKey.USER_DICTIONARY.bytes, this.userDictionary.encode()).put(KvFileHeaderKey.KV_BLOCK_FORMAT.bytes, StringCodec.UTF_8.encode(this.blockFormat));
    }

    public static class KvFileHeaderCodec
    implements Codec<KvFileHeader, BinaryDictionary> {
        private final List<String> registeredBlockFormats;

        public KvFileHeaderCodec(List<String> registeredBlockFormats) {
            this.registeredBlockFormats = registeredBlockFormats;
        }

        @Override
        public BinaryDictionary encode(KvFileHeader value) {
            return value.toBinaryDictionary();
        }

        @Override
        public KvFileHeader decode(BinaryDictionary dictionary) {
            return new KvFileHeader(this.parseUserDictionary(dictionary), this.parseBlockFormat(dictionary));
        }

        private BinaryDictionary parseUserDictionary(BinaryDictionary dictionary) {
            byte[] userDictionaryBytes = dictionary.get(KvFileHeaderKey.USER_DICTIONARY.bytes);
            return BinaryDictionary.decode(userDictionaryBytes);
        }

        private String parseBlockFormat(BinaryDictionary dictionary) {
            byte[] blockFormatBytes = dictionary.get(KvFileHeaderKey.KV_BLOCK_FORMAT.bytes);
            return StringCodec.UTF_8.decode(blockFormatBytes);
        }
    }
}

