/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.codec;

import io.datarouter.bytes.Codec;
import io.datarouter.bytes.kvfile.codec.KvFileEntrySerializer;
import io.datarouter.bytes.kvfile.kv.KvFileEntry;
import io.datarouter.bytes.varint.VarIntTool;
import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class KvFileBlockCodec<T>
implements Codec<List<T>, byte[]> {
    private static final Codec<List<KvFileEntry>, byte[]> IDENTITY = new KvFileBlockCodec(Codec.identity());
    private final Codec<List<T>, byte[]> blockCodec;

    public KvFileBlockCodec(Codec<T, KvFileEntry> kvCodec) {
        KvFileBlockEncoder<Object> encoder = new KvFileBlockEncoder<Object>(kvCodec::encode);
        KvFileBlockDecoder<Object> decoder = new KvFileBlockDecoder<Object>(kvCodec::decode);
        this.blockCodec = Codec.of(encoder::encode, decoder::decode);
    }

    public static Codec<List<KvFileEntry>, byte[]> identity() {
        return IDENTITY;
    }

    @Override
    public byte[] encode(List<T> value) {
        return this.blockCodec.encode(value);
    }

    @Override
    public List<T> decode(byte[] encodedValue) {
        return this.blockCodec.decode(encodedValue);
    }

    private static int encodedLength(List<KvFileEntry> kvs) {
        int sizeBytesLength = VarIntTool.length(kvs.size());
        int dataBytesLength = 0;
        for (KvFileEntry kv : kvs) {
            dataBytesLength += kv.length();
        }
        return sizeBytesLength + dataBytesLength;
    }

    public static class KvFileBlockDecoder<T> {
        private final Function<KvFileEntry, T> decoder;

        public KvFileBlockDecoder(Function<KvFileEntry, T> decoder) {
            this.decoder = decoder;
        }

        public List<T> decode(byte[] bytes) {
            int cursor = 0;
            int size = VarIntTool.decodeInt(bytes, cursor);
            cursor += VarIntTool.length(size);
            ArrayList<T> items = new ArrayList<T>(size);
            int i = 0;
            while (i < size) {
                KvFileEntry kv = KvFileEntrySerializer.fromBytes(bytes, cursor);
                cursor += kv.length();
                items.add(this.decoder.apply(kv));
                ++i;
            }
            return items;
        }
    }

    public static class KvFileBlockEncoder<T> {
        private final Function<T, KvFileEntry> encoder;

        public KvFileBlockEncoder(Function<T, KvFileEntry> encoder) {
            this.encoder = encoder;
        }

        public byte[] encode(List<T> items) {
            List kvs = (List)Scanner.of(items).map(this.encoder::apply).collect(() -> new ArrayList(items.size()));
            int numBytes = KvFileBlockCodec.encodedLength(kvs);
            byte[] bytes = new byte[numBytes];
            int cursor = 0;
            cursor += VarIntTool.encode(bytes, cursor, kvs.size());
            for (KvFileEntry kv : kvs) {
                System.arraycopy(kv.backingBytes(), kv.offset(), bytes, cursor, kv.length());
                cursor += kv.length();
            }
            return bytes;
        }
    }
}

