/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.array.longarray;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.codec.longcodec.RawLongCodec;

public class RawLongArrayCodec {
    public static final RawLongArrayCodec INSTANCE = new RawLongArrayCodec();
    private static final RawLongCodec RAW_LONG_CODEC = RawLongCodec.INSTANCE;
    private static final int ITEM_LENGTH = RAW_LONG_CODEC.length();

    public byte[] encode(long[] values) {
        if (values.length == 0) {
            return EmptyArray.BYTE;
        }
        byte[] bytes = new byte[ITEM_LENGTH * values.length];
        this.encode(values, bytes, 0);
        return bytes;
    }

    public int encode(long[] values, byte[] bytes, int offset) {
        int cursor = offset;
        int i = 0;
        while (i < values.length) {
            RAW_LONG_CODEC.encode(values[i], bytes, cursor);
            cursor += ITEM_LENGTH;
            ++i;
        }
        return values.length * ITEM_LENGTH;
    }

    public long[] decode(byte[] bytes) {
        if (bytes == null) {
            return EmptyArray.LONG;
        }
        return this.decode(bytes, 0, bytes.length);
    }

    public long[] decode(byte[] bytes, int offset, int bytesLength) {
        if (bytesLength == 0) {
            return EmptyArray.LONG;
        }
        if (bytesLength % ITEM_LENGTH != 0) {
            throw new IllegalArgumentException("bytesLength must be multiple of " + ITEM_LENGTH);
        }
        int resultLength = bytesLength / ITEM_LENGTH;
        long[] result = new long[resultLength];
        int cursor = offset;
        int i = 0;
        while (i < resultLength) {
            result[i] = RAW_LONG_CODEC.decode(bytes, cursor);
            cursor += ITEM_LENGTH;
            ++i;
        }
        return result;
    }
}

