/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.write;

import io.datarouter.bytes.BinaryDictionary;
import io.datarouter.bytes.blockfile.Blockfile;
import io.datarouter.bytes.blockfile.checksum.BlockfileChecksummer;
import io.datarouter.bytes.blockfile.checksum.BlockfileStandardChecksummers;
import io.datarouter.bytes.blockfile.compress.BlockfileCompressor;
import io.datarouter.bytes.blockfile.compress.BlockfileStandardCompressors;
import io.datarouter.bytes.blockfile.section.BlockfileHeader;
import io.datarouter.bytes.blockfile.write.BlockfileListener;
import io.datarouter.bytes.blockfile.write.BlockfileWriter;
import io.datarouter.scanner.Threads;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class BlockfileWriterBuilder<T> {
    private final Blockfile<T> blockfile;
    private final Function<T, byte[]> encoder;
    private final String name;
    private BinaryDictionary headerDictionary = new BinaryDictionary();
    private Supplier<BinaryDictionary> footerDictionarySupplier = BinaryDictionary::new;
    private List<BlockfileListener> listeners = new ArrayList<BlockfileListener>();
    private int encodeBatchSize = 1;
    private Threads encodeThreads = Threads.none();
    private BlockfileCompressor compressor = BlockfileStandardCompressors.NONE;
    private BlockfileChecksummer checksummer = BlockfileStandardChecksummers.NONE;
    private boolean multipartWrite = true;
    private Threads writeThreads = Threads.none();

    public BlockfileWriterBuilder(Blockfile<T> blockfile, Function<T, byte[]> encoder, String name) {
        this.blockfile = blockfile;
        this.encoder = encoder;
        this.name = name;
    }

    public BlockfileWriterBuilder<T> setHeaderDictionary(BinaryDictionary headerDictionary) {
        this.headerDictionary = headerDictionary;
        return this;
    }

    public BlockfileWriterBuilder<T> setFooterDictionarySupplier(Supplier<BinaryDictionary> footerDictionarySupplier) {
        this.footerDictionarySupplier = footerDictionarySupplier;
        return this;
    }

    public BlockfileWriterBuilder<T> addListener(BlockfileListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public BlockfileWriterBuilder<T> addListeners(BlockfileListener ... listeners) {
        Arrays.asList(listeners).forEach(this::addListener);
        return this;
    }

    public BlockfileWriterBuilder<T> setEncodeBatchSize(int encodeBatchSize) {
        this.encodeBatchSize = encodeBatchSize;
        return this;
    }

    public BlockfileWriterBuilder<T> setEncodeThreads(Threads encodeThreads) {
        this.encodeThreads = encodeThreads;
        return this;
    }

    public BlockfileWriterBuilder<T> setCompressor(BlockfileCompressor compressor) {
        this.compressor = compressor;
        return this;
    }

    public BlockfileWriterBuilder<T> setChecksummer(BlockfileChecksummer checksummer) {
        this.checksummer = checksummer;
        return this;
    }

    public BlockfileWriterBuilder<T> setMultipartWrite(boolean multipartWrite) {
        this.multipartWrite = multipartWrite;
        return this;
    }

    public BlockfileWriterBuilder<T> disableMultipartWrite() {
        return this.setMultipartWrite(false);
    }

    public BlockfileWriterBuilder<T> setWriteThreads(Threads writeThreads) {
        this.writeThreads = writeThreads;
        return this;
    }

    public BlockfileWriter<T> build() {
        BlockfileHeader.BlockfileHeaderCodec headerCodec = new BlockfileHeader.BlockfileHeaderCodec(this.blockfile.registeredCompressors(), this.blockfile.registeredChecksummers());
        BlockfileWriter.BlockfileWriterConfig<T> config = new BlockfileWriter.BlockfileWriterConfig<T>(this.blockfile.storage(), this.encoder, headerCodec, this.compressor, this.checksummer, this.headerDictionary, this.footerDictionarySupplier, this.listeners, this.encodeBatchSize, this.encodeThreads, this.multipartWrite, this.writeThreads);
        return new BlockfileWriter<T>(config, this.name);
    }
}

