/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.storage;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.blockfile.dto.BlockfileNameAndSize;
import io.datarouter.bytes.blockfile.storage.BlockfileStorage;
import io.datarouter.scanner.Scanner;
import io.datarouter.scanner.Threads;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Stream;

public class BlockfileLocalStorage
implements BlockfileStorage {
    private final String directoryPath;

    public BlockfileLocalStorage(String directoryPath) {
        if (!directoryPath.endsWith("/")) {
            String message = String.format("directoryPath=%s must end with /", directoryPath);
            throw new IllegalArgumentException(message);
        }
        this.directoryPath = directoryPath;
    }

    @Override
    public List<BlockfileNameAndSize> list() {
        Path directory = Path.of(this.directoryPath, new String[0]);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<Path> paths = Files.walk(directory, new FileVisitOption[0]);){
                return Scanner.of(paths).exclude(path -> Files.isDirectory(path, new LinkOption[0])).exclude(Files::isSymbolicLink).include(Files::isReadable).map(Path::getFileName).map(Path::toString).map(name -> new BlockfileNameAndSize((String)name, this.length((String)name))).list();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long length(String name) {
        Path fullPath = this.fullPath(name);
        try {
            return Files.size(fullPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public byte[] read(String name) {
        Path fullPath = this.fullPath(name);
        try {
            return Files.readAllBytes(fullPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public byte[] readPartial(String name, long offset, int length) {
        Path fullPath = this.fullPath(name);
        ByteBuffer buffer = ByteBuffer.allocate(length);
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try (SeekableByteChannel channel = Files.newByteChannel(fullPath, StandardOpenOption.READ);){
                channel.position(offset);
                channel.read(buffer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer.array();
    }

    @Override
    public InputStream readInputStream(String name, Threads threads, ByteLength chunkSize) {
        Path fullPath = this.fullPath(name);
        try {
            return new BufferedInputStream(Files.newInputStream(fullPath, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void write(String name, byte[] bytes) {
        Path fullPath = this.fullPath(name);
        try {
            Files.write(fullPath, bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(String name, InputStream inputStream, Threads threads) {
        Path fullPath = this.fullPath(name);
        fullPath.getParent().toFile().mkdirs();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                InputStream $inputStream = inputStream;
                try {
                    try (OutputStream outputStream = Files.newOutputStream(fullPath, new OpenOption[0]);){
                        fullPath.toFile().createNewFile();
                        inputStream.transferTo(outputStream);
                    }
                    if ($inputStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if ($inputStream == null) throw throwable;
                    $inputStream.close();
                    throw throwable;
                }
                $inputStream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void deleteMulti(List<String> names) {
        Scanner.of(names).map(this::fullPath).forEach(fullPath -> {
            try {
                Files.delete(fullPath);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private Path fullPath(String name) {
        return Path.of(String.valueOf(this.directoryPath) + name, new String[0]);
    }
}

