/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.read;

import io.datarouter.bytes.blockfile.Blockfile;
import io.datarouter.bytes.blockfile.read.BlockfileMetadataReader;
import io.datarouter.bytes.blockfile.section.BlockfileHeader;
import java.util.Optional;

public class BlockfileMetadataReaderBuilder<T> {
    private final Blockfile<T> blockfile;
    private final String name;
    private Optional<Long> knownFileLength = Optional.empty();

    public BlockfileMetadataReaderBuilder(Blockfile<T> blockfile, String name) {
        this.blockfile = blockfile;
        this.name = name;
    }

    public BlockfileMetadataReaderBuilder<T> setKnownFileLength(long knownFileLength) {
        this.knownFileLength = Optional.of(knownFileLength);
        return this;
    }

    public BlockfileMetadataReader<T> build() {
        BlockfileHeader.BlockfileHeaderCodec headerCodec = new BlockfileHeader.BlockfileHeaderCodec(this.blockfile.registeredCompressors(), this.blockfile.registeredChecksummers());
        BlockfileMetadataReader.BlockfileMetadataReaderConfig config = new BlockfileMetadataReader.BlockfileMetadataReaderConfig(this.blockfile.storage(), headerCodec, this.knownFileLength);
        return new BlockfileMetadataReader(config, this.name);
    }
}

