/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.enums;

public enum BlockfileSection {
    HEADER('H'),
    BLOCK('B'),
    FOOTER('F'),
    TRAILER('T');

    public final char code;
    public final byte codeByte;
    public final byte[] codeBytes;

    private BlockfileSection(char code) {
        this.code = code;
        this.codeByte = (byte)code;
        this.codeBytes = new byte[]{this.codeByte};
    }

    public static BlockfileSection decode(char code) {
        return switch (code) {
            case 'H' -> HEADER;
            case 'B' -> BLOCK;
            case 'F' -> FOOTER;
            case 'T' -> TRAILER;
            default -> throw new IllegalArgumentException(String.format("unknown code=%s", Character.valueOf(code)));
        };
    }
}

