/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.checksum;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.blockfile.checksum.BlockfileChecksumTool;
import io.datarouter.bytes.blockfile.checksum.BlockfileChecksummer;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.CRC32;

public class BlockfileStandardChecksummers {
    public static final BlockfileChecksummer NONE = new BlockfileChecksummer("NONE", 0, $ -> EmptyArray.BYTE);
    public static final BlockfileChecksummer ADLER_32 = new BlockfileChecksummer("ADLER_32", 4, data -> BlockfileChecksumTool.checksum32(new Adler32(), data));
    public static final BlockfileChecksummer CRC_32 = new BlockfileChecksummer("CRC_32", 4, data -> BlockfileChecksumTool.checksum32(new CRC32(), data));
    public static final List<BlockfileChecksummer> ALL = List.of(NONE, ADLER_32, CRC_32);
    public static final Map<String, BlockfileChecksummer> BY_ENCODED_NAME = Scanner.of(ALL).toMap(BlockfileChecksummer::encodedName);
}

