/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.bytes.codec.bytestringcodec.HexByteStringCodec;
import java.io.PrintStream;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class HexBlockTool {
    public static String toHexBlock(byte[] bytes, int numTabs, int width) {
        if (width % 2 != 0) {
            throw new IllegalArgumentException("Please specify an even width");
        }
        String tabs = IntStream.range(0, numTabs).mapToObj($ -> "\t").collect(Collectors.joining(""));
        String hex = HexByteStringCodec.INSTANCE.encode(bytes);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < hex.length()) {
            if (i > 0) {
                sb.append("\n");
            }
            int from = i;
            int to = Math.min(hex.length(), from + width);
            sb.append(tabs);
            String line = hex.substring(from, to);
            sb.append(line);
            i += width;
        }
        return sb.toString();
    }

    public static void print(byte[] bytes, int numTabs, int width) {
        PrintStream out = System.out;
        String header = String.format("##### hex start tabs=%s width=%s #####", numTabs, width);
        String body = HexBlockTool.toHexBlock(bytes, numTabs, width);
        String footer = "##### hex end #####";
        out.println(header);
        out.println(body);
        out.println(footer);
    }

    public static void print(byte[] bytes) {
        HexBlockTool.print(bytes, 0, 80);
    }

    public static byte[] fromHexBlock(String hexBlock) {
        String trimmed = HexBlockTool.trim(hexBlock);
        return HexByteStringCodec.INSTANCE.decode(trimmed);
    }

    public static String trim(String hexBlock) {
        CharSequence[] lines = hexBlock.split("\n");
        return String.join((CharSequence)"", lines);
    }
}

