/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.kv;

import io.datarouter.bytes.io.InputStreamTool;
import java.io.InputStream;
import java.util.Comparator;

public enum KvFileOp {
    DELETE(0),
    PUT(1);

    public static final int NUM_PERSISTENT_BYTES = 1;
    public static final Comparator<KvFileOp> COMPARATOR;
    private static final KvFileOp[] PERSISTENT_VALUE_LOOKUP_TABLE;
    public final byte persistentValue;
    public final byte[] persistentValueArray;

    static {
        COMPARATOR = Comparator.comparing(op -> op.persistentValue);
        PERSISTENT_VALUE_LOOKUP_TABLE = new KvFileOp[]{DELETE, PUT};
    }

    private KvFileOp(byte persistentValue) {
        this.persistentValue = persistentValue;
        this.persistentValueArray = new byte[]{persistentValue};
    }

    public static final KvFileOp fromByte(byte value) {
        return PERSISTENT_VALUE_LOOKUP_TABLE[value];
    }

    public static final KvFileOp fromInputStream(InputStream inputStream) {
        byte value = InputStreamTool.readRequiredByte(inputStream);
        return PERSISTENT_VALUE_LOOKUP_TABLE[value];
    }
}

