/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.io.read;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.blockfile.read.BlockfileMetadataReader;
import io.datarouter.bytes.blockfile.read.BlockfileMetadataReaderBuilder;
import io.datarouter.bytes.blockfile.read.BlockfileReader;
import io.datarouter.bytes.blockfile.read.BlockfileReaderBuilder;
import io.datarouter.bytes.kvfile.codec.KvFileBlockCodec;
import io.datarouter.bytes.kvfile.io.KvFile;
import io.datarouter.bytes.kvfile.io.read.KvFileMetadataReader;
import io.datarouter.bytes.kvfile.io.read.KvFileReader;
import io.datarouter.bytes.kvfile.kv.KvFileEntry;
import io.datarouter.scanner.Threads;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class KvFileReaderBuilder<T> {
    private final KvFile<T> kvFile;
    private final Function<byte[], List<T>> blockDecoder;
    private final String pathAndFile;
    private final BlockfileReaderBuilder<List<T>> blockfileReaderBuilder;

    public KvFileReaderBuilder(KvFile<T> kvFile, Function<KvFileEntry, T> decoder, String pathAndFile, Optional<Long> optKnownFileLength) {
        this.kvFile = kvFile;
        this.blockDecoder = new KvFileBlockCodec.KvFileBlockDecoder<T>(decoder)::decode;
        this.pathAndFile = pathAndFile;
        BlockfileMetadataReaderBuilder<List<T>> blockfileMetadataReaderBuilder = kvFile.blockfile().newMetadataReaderBuilder(pathAndFile);
        optKnownFileLength.ifPresent(blockfileMetadataReaderBuilder::setKnownFileLength);
        BlockfileMetadataReader<List<T>> blockfileMetadataReader = blockfileMetadataReaderBuilder.build();
        this.blockfileReaderBuilder = kvFile.blockfile().newReaderBuilder(blockfileMetadataReader, this.blockDecoder);
    }

    public KvFileReaderBuilder<T> setReadThreads(Threads readThreads) {
        this.blockfileReaderBuilder.setReadThreads(readThreads);
        return this;
    }

    public KvFileReaderBuilder<T> setReadChunkSize(ByteLength readChunkSize) {
        this.blockfileReaderBuilder.setReadChunkSize(readChunkSize);
        return this;
    }

    public KvFileReaderBuilder<T> setDecodeBatchSize(int decodeBatchSize) {
        this.blockfileReaderBuilder.setDecodeBatchSize(decodeBatchSize);
        return this;
    }

    public KvFileReaderBuilder<T> setDecodeThreads(Threads decodeThreads) {
        this.blockfileReaderBuilder.setDecodeThreads(decodeThreads);
        return this;
    }

    public KvFileReaderBuilder<T> enableChecksumValidation() {
        this.blockfileReaderBuilder.enableChecksumValidation();
        return this;
    }

    public KvFileReader<T> build() {
        BlockfileReader<List<T>> blockfileReader = this.blockfileReaderBuilder.build();
        KvFileMetadataReader.KvFileMetadataReaderConfig<T> kvFileMetadataReaderConfig = new KvFileMetadataReader.KvFileMetadataReaderConfig<T>(blockfileReader.metadataReader(), this.kvFile.kvBlockFormats());
        KvFileMetadataReader<T> kvFileMetadataReader = new KvFileMetadataReader<T>(kvFileMetadataReaderConfig);
        KvFileReader.KvFileReaderConfig<T> kvFileReaderConfig = new KvFileReader.KvFileReaderConfig<T>(blockfileReader, kvFileMetadataReader);
        return new KvFileReader<T>(kvFileReaderConfig);
    }
}

