/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.kvfile.io.read;

import io.datarouter.bytes.BinaryDictionary;
import io.datarouter.bytes.blockfile.read.BlockfileMetadataCache;
import io.datarouter.bytes.blockfile.read.BlockfileMetadataReader;
import io.datarouter.bytes.kvfile.io.footer.KvFileFooter;
import io.datarouter.bytes.kvfile.io.header.KvFileHeader;
import java.util.List;

public class KvFileMetadataReader<T> {
    private final KvFileMetadataReaderConfig<T> config;
    private final BlockfileMetadataCache<KvFileHeader> cachedDecodedHeader = new BlockfileMetadataCache<KvFileHeader>(this::loadDecodedHeader);
    private final BlockfileMetadataCache<KvFileFooter> cachedDecodedFooter = new BlockfileMetadataCache<KvFileFooter>(this::loadDecodedFooter);

    public KvFileMetadataReader(KvFileMetadataReaderConfig<T> config) {
        this.config = config;
    }

    public BlockfileMetadataReader<List<T>> blockfileMetadataReader() {
        return this.config.blockfileMetadataReader();
    }

    private KvFileHeader loadDecodedHeader() {
        BinaryDictionary kvHeaderDictionary = this.blockfileMetadataReader().header().userDictionary();
        return new KvFileHeader.KvFileHeaderCodec(this.config.blockFormats()).decode(kvHeaderDictionary);
    }

    public KvFileHeader header() {
        return this.cachedDecodedHeader.get();
    }

    private KvFileFooter loadDecodedFooter() {
        BinaryDictionary kvFooterDictionary = this.blockfileMetadataReader().footer().userDictionary();
        return KvFileFooter.DICTIONARY_CODEC.decode(kvFooterDictionary);
    }

    public KvFileFooter footer() {
        return this.cachedDecodedFooter.get();
    }

    public record KvFileMetadataReaderConfig<T>(BlockfileMetadataReader<List<T>> blockfileMetadataReader, List<String> blockFormats) {
    }
}

