/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.digest;

import io.datarouter.bytes.digest.Digest;
import io.datarouter.bytes.digest.DigestAlgorithm;
import io.datarouter.bytes.digest.DigestStream;
import io.datarouter.bytes.io.InputStreamTool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;

public class DigestTool {
    public static Digest digest(String input, DigestAlgorithm hashFunction) {
        return new Digest(hashFunction.getMessageDigest().digest(input.getBytes()));
    }

    public static Digest digest(Path path, DigestAlgorithm hashFunction) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DigestStream stream = DigestTool.startDigestStream(path, hashFunction);){
                InputStreamTool.transferTo(stream.getStream(), OutputStream.nullOutputStream());
                return stream.digest();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static DigestStream startDigestStream(Path path, DigestAlgorithm hashFunction) {
        MessageDigest instance = hashFunction.getMessageDigest();
        try {
            InputStream is = Files.newInputStream(path, new OpenOption[0]);
            DigestInputStream dis = new DigestInputStream(is, instance);
            return new DigestStream(dis);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

