/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.array.shortarray;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.codec.shortcodec.ComparableShortCodec;

public class ComparableShortArrayCodec {
    public static final ComparableShortArrayCodec INSTANCE = new ComparableShortArrayCodec();
    private static final ComparableShortCodec COMPARABLE_SHORT_CODEC = ComparableShortCodec.INSTANCE;
    private static final int ITEM_LENGTH = COMPARABLE_SHORT_CODEC.length();

    public int itemLength() {
        return ITEM_LENGTH;
    }

    public byte[] encode(short[] values) {
        if (values.length == 0) {
            return EmptyArray.BYTE;
        }
        byte[] bytes = new byte[ITEM_LENGTH * values.length];
        this.encode(values, bytes, 0);
        return bytes;
    }

    public int encode(short[] values, byte[] bytes, int offset) {
        int cursor = offset;
        int i = 0;
        while (i < values.length) {
            COMPARABLE_SHORT_CODEC.encode(values[i], bytes, cursor);
            cursor += ITEM_LENGTH;
            ++i;
        }
        return values.length * ITEM_LENGTH;
    }

    public short[] decode(byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    public short[] decode(byte[] bytes, int offset, int bytesLength) {
        if (bytesLength == 0) {
            return EmptyArray.SHORT;
        }
        if (bytesLength % ITEM_LENGTH != 0) {
            throw new IllegalArgumentException("bytesLength must be multiple of " + ITEM_LENGTH);
        }
        int resultLength = bytesLength / ITEM_LENGTH;
        short[] result = new short[resultLength];
        int cursor = offset;
        int i = 0;
        while (i < resultLength) {
            result[i] = COMPARABLE_SHORT_CODEC.decode(bytes, cursor);
            cursor += ITEM_LENGTH;
            ++i;
        }
        return result;
    }
}

