/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.array.chararray;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.codec.charcodec.ComparableCharCodec;

public class ComparableCharArrayCodec {
    public static final ComparableCharArrayCodec INSTANCE = new ComparableCharArrayCodec();
    private static final ComparableCharCodec COMPARABLE_CHAR_CODEC = ComparableCharCodec.INSTANCE;
    private static final int ITEM_LENGTH = COMPARABLE_CHAR_CODEC.length();

    public int itemLength() {
        return ITEM_LENGTH;
    }

    public byte[] encode(char[] values) {
        if (values.length == 0) {
            return EmptyArray.BYTE;
        }
        byte[] bytes = new byte[ITEM_LENGTH * values.length];
        this.encode(values, bytes, 0);
        return bytes;
    }

    public int encode(char[] values, byte[] bytes, int offset) {
        int cursor = offset;
        int i = 0;
        while (i < values.length) {
            COMPARABLE_CHAR_CODEC.encode(values[i], bytes, cursor);
            cursor += ITEM_LENGTH;
            ++i;
        }
        return values.length * ITEM_LENGTH;
    }

    public char[] decode(byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    public char[] decode(byte[] bytes, int offset, int bytesLength) {
        if (bytesLength == 0) {
            return EmptyArray.CHAR;
        }
        if (bytesLength % ITEM_LENGTH != 0) {
            throw new IllegalArgumentException("bytesLength must be multiple of " + ITEM_LENGTH);
        }
        int resultLength = bytesLength / ITEM_LENGTH;
        char[] result = new char[resultLength];
        int cursor = offset;
        int i = 0;
        while (i < resultLength) {
            result[i] = COMPARABLE_CHAR_CODEC.decode(bytes, cursor);
            cursor += ITEM_LENGTH;
            ++i;
        }
        return result;
    }
}

