/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.section;

import io.datarouter.bytes.BinaryDictionary;
import io.datarouter.bytes.Codec;
import io.datarouter.bytes.blockfile.checksum.BlockfileChecksummer;
import io.datarouter.bytes.blockfile.checksum.BlockfileChecksummers;
import io.datarouter.bytes.blockfile.compress.BlockfileCompressor;
import io.datarouter.bytes.blockfile.compress.BlockfileCompressors;
import io.datarouter.bytes.blockfile.enums.BlockfileHeaderKey;

public record BlockfileHeader(BinaryDictionary userDictionary, BlockfileCompressor compressor, int checksumLength, BlockfileChecksummer checksummer) {
    private BinaryDictionary toBinaryDictionary() {
        return new BinaryDictionary().put(BlockfileHeaderKey.USER_DICTIONARY.bytes, this.userDictionary.encode()).put(BlockfileHeaderKey.COMPRESSOR.bytes, this.compressor.nameToBytes()).put(BlockfileHeaderKey.CHECKSUM_LENGTH.bytes, this.checksummer.lengthToBytes()).put(BlockfileHeaderKey.CHECKSUM_ALGORITHM.bytes, this.checksummer.nameToBytes());
    }

    public static class BlockfileHeaderCodec
    implements Codec<BlockfileHeader, byte[]> {
        private final BlockfileCompressors registeredCompressors;
        private final BlockfileChecksummers registeredChecksummers;

        public BlockfileHeaderCodec(BlockfileCompressors registeredCompressors, BlockfileChecksummers registeredChecksummers) {
            this.registeredCompressors = registeredCompressors;
            this.registeredChecksummers = registeredChecksummers;
        }

        @Override
        public byte[] encode(BlockfileHeader value) {
            return value.toBinaryDictionary().encode();
        }

        @Override
        public BlockfileHeader decode(byte[] valueBytes) {
            BinaryDictionary dictionary = BinaryDictionary.decode(valueBytes);
            return new BlockfileHeader(this.parseUserDictionary(dictionary), this.parseCompressor(dictionary), this.parseChecksumLength(dictionary), this.parseChecksummer(dictionary));
        }

        private BinaryDictionary parseUserDictionary(BinaryDictionary dictionary) {
            byte[] userDictionaryBytes = dictionary.get(BlockfileHeaderKey.USER_DICTIONARY.bytes);
            return BinaryDictionary.decode(userDictionaryBytes);
        }

        private BlockfileCompressor parseCompressor(BinaryDictionary dictionary) {
            byte[] compressorNameBytes = dictionary.get(BlockfileHeaderKey.COMPRESSOR.bytes);
            String compressorName = BlockfileCompressor.bytesToName(compressorNameBytes);
            return this.registeredCompressors.getForEncodedName(compressorName);
        }

        private int parseChecksumLength(BinaryDictionary dictionary) {
            byte[] checksumLengthBytes = dictionary.get(BlockfileHeaderKey.CHECKSUM_LENGTH.bytes);
            return BlockfileChecksummer.bytesToLength(checksumLengthBytes);
        }

        private BlockfileChecksummer parseChecksummer(BinaryDictionary dictionary) {
            byte[] checksummerNameBytes = dictionary.get(BlockfileHeaderKey.CHECKSUM_ALGORITHM.bytes);
            String checksummerName = BlockfileChecksummer.bytesToName(checksummerNameBytes);
            return this.registeredChecksummers.getForEncodedName(checksummerName);
        }
    }
}

