/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.section;

import io.datarouter.bytes.BinaryDictionary;
import io.datarouter.bytes.Codec;
import io.datarouter.bytes.blockfile.enums.BlockfileFooterKey;
import io.datarouter.bytes.varint.VarIntTool;

public record BlockfileFooter(BinaryDictionary userDictionary, long blockCount) {
    public static final Codec<BlockfileFooter, byte[]> VALUE_CODEC = Codec.of(footer -> footer.toBinaryDictionary().encode(), bytes -> {
        BinaryDictionary dictionary = BinaryDictionary.decode(bytes);
        return new BlockfileFooter(BlockfileFooter.parseUserDictionary(dictionary), BlockfileFooter.parseBlockCount(dictionary));
    });

    private BinaryDictionary toBinaryDictionary() {
        return new BinaryDictionary().put(BlockfileFooterKey.USER_DICTIONARY.bytes, this.userDictionary.encode()).put(BlockfileFooterKey.BLOCK_COUNT.bytes, VarIntTool.encode(this.blockCount));
    }

    private static BinaryDictionary parseUserDictionary(BinaryDictionary dictionary) {
        byte[] userDictionaryBytes = dictionary.get(BlockfileFooterKey.USER_DICTIONARY.bytes);
        return BinaryDictionary.decode(userDictionaryBytes);
    }

    private static long parseBlockCount(BinaryDictionary dictionary) {
        byte[] blockCountBytes = dictionary.get(BlockfileFooterKey.BLOCK_COUNT.bytes);
        return VarIntTool.decodeLong(blockCountBytes);
    }
}

