/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.read;

import io.datarouter.bytes.ByteLength;
import io.datarouter.bytes.blockfile.Blockfile;
import io.datarouter.bytes.blockfile.read.BlockfileMetadataReader;
import io.datarouter.bytes.blockfile.read.BlockfileReader;
import io.datarouter.bytes.blockfile.section.BlockfileHeader;
import io.datarouter.scanner.Threads;
import java.util.Optional;
import java.util.function.Function;

public class BlockfileReaderBuilder<T> {
    private final Blockfile<T> blockfile;
    private final BlockfileMetadataReader<T> metadataReader;
    private final Function<byte[], T> decoder;
    private Threads readThreads = Threads.none();
    private ByteLength readChunkSize = ByteLength.ofMiB(4L);
    private int decodeBatchSize = 1;
    private Threads decodeThreads = Threads.none();
    private boolean validateChecksums = false;
    private Optional<Long> knownFileLength = Optional.empty();

    public BlockfileReaderBuilder(Blockfile<T> blockfile, BlockfileMetadataReader<T> metadataReader, Function<byte[], T> decoder) {
        this.blockfile = blockfile;
        this.metadataReader = metadataReader;
        this.decoder = decoder;
    }

    public BlockfileReaderBuilder<T> setReadThreads(Threads readThreads) {
        this.readThreads = readThreads;
        return this;
    }

    public BlockfileReaderBuilder<T> setReadChunkSize(ByteLength readChunkSize) {
        this.readChunkSize = readChunkSize;
        return this;
    }

    public BlockfileReaderBuilder<T> setDecodeBatchSize(int decodeBatchSize) {
        this.decodeBatchSize = decodeBatchSize;
        return this;
    }

    public BlockfileReaderBuilder<T> setDecodeThreads(Threads decodeThreads) {
        this.decodeThreads = decodeThreads;
        return this;
    }

    public BlockfileReaderBuilder<T> enableChecksumValidation() {
        this.validateChecksums = true;
        return this;
    }

    public BlockfileReader<T> build() {
        BlockfileHeader.BlockfileHeaderCodec headerCodec = new BlockfileHeader.BlockfileHeaderCodec(this.blockfile.registeredCompressors(), this.blockfile.registeredChecksummers());
        BlockfileReader.BlockfileReaderConfig<T> config = new BlockfileReader.BlockfileReaderConfig<T>(this.blockfile.storage(), this.decoder, headerCodec, this.readThreads, this.readChunkSize, this.decodeBatchSize, this.decodeThreads, this.validateChecksums, this.knownFileLength);
        return new BlockfileReader<T>(this.metadataReader, config);
    }
}

