/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile.listener;

import io.datarouter.bytes.blockfile.dto.BlockfileTokens;
import io.datarouter.bytes.blockfile.enums.BlockfileSection;
import io.datarouter.bytes.blockfile.write.BlockfileListener;
import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class BlockfileTokensListener
implements BlockfileListener {
    private final Consumer<List<BlockfileTokens>> onComplete;
    private final List<BlockfileTokens> blockTokens = new ArrayList<BlockfileTokens>();

    public BlockfileTokensListener(Consumer<List<BlockfileTokens>> onComplete) {
        this.onComplete = onComplete;
    }

    @Override
    public void accept(BlockfileTokens tokens) {
        this.blockTokens.add(tokens);
    }

    public List<BlockfileTokens> blockTokens() {
        return this.blockTokens;
    }

    public Scanner<BlockfileTokens> scanHeaderAndBlockTokens() {
        return Scanner.of(this.blockTokens).include(tokens -> tokens.section() == BlockfileSection.HEADER || tokens.section() == BlockfileSection.BLOCK);
    }

    public Optional<BlockfileTokens> lastBlockTokens() {
        return this.blockTokens.isEmpty() ? Optional.empty() : Optional.of(this.blockTokens.get(this.blockTokens.size() - 1));
    }

    @Override
    public void complete() {
        this.onComplete.accept(this.blockTokens);
    }
}

