/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.blockfile;

import io.datarouter.bytes.blockfile.Blockfile;
import io.datarouter.bytes.blockfile.checksum.BlockfileChecksummer;
import io.datarouter.bytes.blockfile.checksum.BlockfileChecksummers;
import io.datarouter.bytes.blockfile.checksum.BlockfileStandardChecksummers;
import io.datarouter.bytes.blockfile.compress.BlockfileCompressor;
import io.datarouter.bytes.blockfile.compress.BlockfileCompressors;
import io.datarouter.bytes.blockfile.compress.BlockfileStandardCompressors;
import io.datarouter.bytes.blockfile.storage.BlockfileStorage;

public class BlockfileBuilder<T> {
    private final BlockfileStorage storage;
    private final BlockfileCompressors registeredCompressors = new BlockfileCompressors(BlockfileStandardCompressors.ALL);
    private final BlockfileChecksummers registeredChecksummers = new BlockfileChecksummers(BlockfileStandardChecksummers.ALL);

    public BlockfileBuilder(BlockfileStorage storage) {
        this.storage = storage;
    }

    public BlockfileBuilder<T> registerCompressor(BlockfileCompressor compressor) {
        this.registeredCompressors.add(compressor);
        return this;
    }

    public BlockfileBuilder<T> registerChecksummer(BlockfileChecksummer checksummer) {
        this.registeredChecksummers.add(checksummer);
        return this;
    }

    public Blockfile<T> build() {
        return new Blockfile(this.storage, this.registeredCompressors, this.registeredChecksummers);
    }
}

