/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.internal;

import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.binarydto.fieldcodec.BinaryDtoBaseFieldCodec;
import io.datarouter.bytes.binarydto.internal.BinaryDtoFieldCodecs;
import io.datarouter.bytes.binarydto.internal.BinaryDtoFieldMetadataParser;
import io.datarouter.bytes.binarydto.internal.BinaryDtoReflectionTool;
import io.datarouter.bytes.codec.array.bytearray.TerminatedByteArrayCodec;
import java.lang.reflect.Field;
import java.util.Objects;

public class BinaryDtoFieldSchema<F> {
    public final Field field;
    private final boolean isNullable;
    private final BinaryDtoBaseFieldCodec<F> codec;

    public BinaryDtoFieldSchema(Field field) {
        this.field = field;
        BinaryDtoFieldMetadataParser fieldMetadataParser = new BinaryDtoFieldMetadataParser(field);
        this.isNullable = fieldMetadataParser.isNullable();
        this.codec = BinaryDtoFieldCodecs.getCodecForField(field);
        Objects.requireNonNull(this.codec);
    }

    public String getName() {
        return this.field.getName();
    }

    public String getCodecName() {
        return this.codec.getClass().getSimpleName();
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isNull(Object dto) {
        return this.getFieldValue(dto) == null;
    }

    public boolean isKeyCompatible() {
        return this.codec.supportsComparableCodec();
    }

    public byte[] encodeComparable(Object dto) {
        F fieldValue = this.getFieldValue(dto);
        byte[] value = this.codec.encode(fieldValue);
        return this.codec.isFixedLength() ? value : TerminatedByteArrayCodec.INSTANCE.encode(value);
    }

    public int decodeComparableLength(byte[] bytes, int offset) {
        return this.codec.isFixedLength() ? this.codec.fixedLength() : TerminatedByteArrayCodec.INSTANCE.lengthWithTerminalIndex(bytes, offset);
    }

    public int decodeComparable(Object object, byte[] bytes, int offset) {
        int cursor = offset;
        F fieldValue = null;
        if (this.codec.isFixedLength()) {
            fieldValue = this.codec.decode(bytes, cursor, this.codec.fixedLength());
            cursor += this.codec.fixedLength();
        } else {
            LengthAndValue<byte[]> lengthAndEncodedValue = TerminatedByteArrayCodec.INSTANCE.decode(bytes, cursor);
            cursor += lengthAndEncodedValue.length;
            fieldValue = this.codec.decode((byte[])lengthAndEncodedValue.value);
        }
        this.setFieldValue(object, fieldValue);
        return cursor - offset;
    }

    public byte[] encodeIndexed(Object dto) {
        F fieldValue = this.getFieldValue(dto);
        return this.codec.encode(fieldValue);
    }

    public void decodeIndexed(Object object, byte[] bytes) {
        F fieldValue = null;
        if (this.codec.isFixedLength() && bytes.length != this.codec.fixedLength()) {
            String message = String.format("bytes.length=%s != codec.fixedLength=%s", bytes.length, this.codec.fixedLength());
            throw new RuntimeException(message);
        }
        fieldValue = this.codec.decode(bytes);
        this.setFieldValue(object, fieldValue);
    }

    public int compareFieldValuesAsIfEncoded(Object left, Object right) {
        F leftValue = this.getFieldValue(left);
        F rightValue = this.getFieldValue(right);
        if (leftValue == null && rightValue == null) {
            return 0;
        }
        if (leftValue == null) {
            return -1;
        }
        if (rightValue == null) {
            return 1;
        }
        return this.codec.compareAsIfEncoded(leftValue, rightValue);
    }

    private F getFieldValue(Object dto) {
        return (F)BinaryDtoReflectionTool.getUnchecked(this.field, dto);
    }

    private void setFieldValue(Object dto, F fieldValue) {
        BinaryDtoReflectionTool.setUnchecked(this.field, dto, fieldValue);
    }
}

