/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.fieldcodec.other;

import io.datarouter.bytes.binarydto.fieldcodec.BinaryDtoBaseFieldCodec;
import io.datarouter.bytes.codec.stringcodec.StringCodec;

public class EnumBinaryDtoFieldCodec<E extends Enum<E>>
extends BinaryDtoBaseFieldCodec<E> {
    private static final StringCodec CODEC = StringCodec.US_ASCII;
    private final Class<E> type;

    public EnumBinaryDtoFieldCodec(Class<E> type) {
        this.type = type;
    }

    @Override
    public boolean supportsComparableCodec() {
        return true;
    }

    @Override
    public byte[] encode(E value) {
        return CODEC.encode(((Enum)value).name());
    }

    @Override
    public E decode(byte[] bytes, int offset, int length) {
        String stringValue = CODEC.decode(bytes, offset, length);
        return Enum.valueOf(this.type, stringValue);
    }

    @Override
    public int compareAsIfEncoded(E left, E right) {
        return ((Enum)left).name().compareTo(((Enum)right).name());
    }
}

