/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.codec.bytearray;

import io.datarouter.bytes.VarIntTool;
import io.datarouter.bytes.binarydto.codec.BinaryDtoIndexedCodec;
import io.datarouter.bytes.binarydto.dto.BaseBinaryDto;
import io.datarouter.scanner.Scanner;
import java.util.List;

public class MultiBinaryDtoEncoder<T extends BaseBinaryDto<T>> {
    private final BinaryDtoIndexedCodec<T> codec;

    public MultiBinaryDtoEncoder(Class<T> dtoClass) {
        this.codec = BinaryDtoIndexedCodec.of(dtoClass);
    }

    public MultiBinaryDtoEncoder(BinaryDtoIndexedCodec<T> codec) {
        this.codec = codec;
    }

    public Scanner<byte[]> encode(List<T> dtos) {
        return this.encode(Scanner.of(dtos));
    }

    public Scanner<byte[]> encode(Scanner<T> dtos) {
        return dtos.concat(dto -> {
            byte[] dataBytes = this.codec.encode((BaseBinaryDto)dto);
            byte[] lengthBytes = VarIntTool.encode(dataBytes.length);
            return Scanner.of((Object[])new byte[][]{lengthBytes, dataBytes});
        });
    }
}

