/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.codec.bytearray;

import io.datarouter.bytes.VarIntTool;
import io.datarouter.bytes.binarydto.codec.BinaryDtoIndexedCodec;
import io.datarouter.bytes.binarydto.dto.BaseBinaryDto;
import io.datarouter.scanner.BaseScanner;
import io.datarouter.scanner.Scanner;

public class BinaryDtoByteArrayScanner<T extends BaseBinaryDto<T>>
extends BaseScanner<T> {
    private final BinaryDtoIndexedCodec<T> codec;
    private final byte[] bytes;
    private int cursor;

    public BinaryDtoByteArrayScanner(Class<T> dtoClass, byte[] bytes) {
        this.codec = BinaryDtoIndexedCodec.of(dtoClass);
        this.bytes = bytes;
        this.cursor = 0;
    }

    public static <T extends BaseBinaryDto<T>> Scanner<T> of(Class<T> dtoClass, byte[] bytes) {
        return new BinaryDtoByteArrayScanner<T>(dtoClass, bytes);
    }

    public boolean advance() {
        if (this.cursor == this.bytes.length) {
            return false;
        }
        int length = VarIntTool.decodeInt(this.bytes, this.cursor);
        this.cursor += VarIntTool.length(length);
        T value = this.codec.decode(this.bytes, this.cursor, length);
        this.current = value;
        this.cursor += length;
        return true;
    }
}

