/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.codec;

import io.datarouter.bytes.ByteTool;
import io.datarouter.bytes.Codec;
import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.binarydto.dto.ComparableBinaryDto;
import io.datarouter.bytes.binarydto.internal.BinaryDtoAllocator;
import io.datarouter.bytes.binarydto.internal.BinaryDtoFieldSchema;
import io.datarouter.bytes.binarydto.internal.BinaryDtoMetadataParser;
import io.datarouter.bytes.binarydto.internal.BinaryDtoNullFieldTool;
import io.datarouter.scanner.Scanner;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BinaryDtoComparableCodec<T extends ComparableBinaryDto<T>>
implements Codec<T, byte[]> {
    private static final Map<Class<? extends ComparableBinaryDto<?>>, BinaryDtoComparableCodec<?>> CACHE = new ConcurrentHashMap();
    private static final int MAX_TOKENS_PER_FIELD = 2;
    public final Class<T> dtoClass;
    public final List<Field> fields;
    public final List<? extends BinaryDtoFieldSchema<?>> fieldSchemas;

    private BinaryDtoComparableCodec(Class<T> dtoClass) {
        this.dtoClass = dtoClass;
        ComparableBinaryDto dto = (ComparableBinaryDto)BinaryDtoAllocator.allocate(dtoClass);
        BinaryDtoMetadataParser<ComparableBinaryDto> metadataParser = new BinaryDtoMetadataParser<ComparableBinaryDto>(dto);
        this.fields = metadataParser.listFields();
        this.fieldSchemas = Scanner.of(this.fields).map(field -> {
            if (field == null) {
                return null;
            }
            field.setAccessible(true);
            BinaryDtoFieldSchema fieldSchema = new BinaryDtoFieldSchema((Field)field);
            if (!fieldSchema.isKeyCompatible()) {
                String message = String.format("FieldCodec=%s for field=%s is not compatible with key encoding for Dto=%s", fieldSchema.getCodecName(), fieldSchema.getName(), dtoClass.getCanonicalName());
                throw new IllegalArgumentException(message);
            }
            return fieldSchema;
        }).list();
    }

    public static <T extends ComparableBinaryDto<T>> BinaryDtoComparableCodec<T> of(Class<? extends T> dtoClass) {
        BinaryDtoComparableCodec<Object> codec = CACHE.get(dtoClass);
        if (codec == null) {
            codec = new BinaryDtoComparableCodec<T>(dtoClass);
            CACHE.put(dtoClass, codec);
        }
        return codec;
    }

    public List<Field> getFieldsOrdered() {
        return this.fields;
    }

    @Override
    public byte[] encode(T dto) {
        return this.encodePrefix(dto, this.fieldSchemas.size());
    }

    public byte[] encodePrefix(T dto, int numFields) {
        ArrayList<byte[]> tokens = new ArrayList<byte[]>(2 * this.fieldSchemas.size());
        int i = 0;
        while (i < numFields) {
            BinaryDtoFieldSchema<?> fieldSchema = this.fieldSchemas.get(i);
            if (fieldSchema != null) {
                if (fieldSchema.isNullable()) {
                    if (fieldSchema.isNull(dto)) {
                        tokens.add(BinaryDtoNullFieldTool.NULL_INDICATOR_TRUE_ARRAY);
                    } else {
                        tokens.add(BinaryDtoNullFieldTool.NULL_INDICATOR_FALSE_ARRAY);
                        tokens.add(fieldSchema.encodeComparable(dto));
                    }
                } else {
                    if (fieldSchema.isNull(dto)) {
                        String message = String.format("field=%s of class=%s can't contain nulls", fieldSchema.getName(), dto.getClass().getCanonicalName());
                        throw new IllegalArgumentException(message);
                    }
                    tokens.add(fieldSchema.encodeComparable(dto));
                }
            }
            ++i;
        }
        return ByteTool.concat(tokens);
    }

    @Override
    public T decode(byte[] bytes) {
        return (T)((ComparableBinaryDto)this.decodeWithLength((byte[])bytes, (int)0).value);
    }

    public LengthAndValue<T> decodeWithLength(byte[] bytes, int offset) {
        ComparableBinaryDto dto = (ComparableBinaryDto)BinaryDtoAllocator.allocate(this.dtoClass);
        int cursor = offset;
        int index = 0;
        while (index < this.fieldSchemas.size()) {
            BinaryDtoFieldSchema<?> fieldSchema = this.fieldSchemas.get(index);
            boolean isNull = false;
            if (fieldSchema.isNullable()) {
                isNull = BinaryDtoNullFieldTool.decodeNullIndicator(bytes[cursor]);
                ++cursor;
            }
            if (!isNull) {
                cursor += fieldSchema.decodeComparable(dto, bytes, cursor);
            }
            ++index;
        }
        int length = cursor - offset;
        return new LengthAndValue<ComparableBinaryDto>(length, dto);
    }

    public int decodePrefixLength(byte[] bytes, int offset, int numFields) {
        int cursor = offset;
        int index = 0;
        while (index < numFields) {
            BinaryDtoFieldSchema<?> fieldSchema = this.fieldSchemas.get(index);
            boolean isNull = false;
            if (fieldSchema.isNullable()) {
                isNull = BinaryDtoNullFieldTool.decodeNullIndicator(bytes[cursor]);
                ++cursor;
            }
            if (!isNull) {
                cursor += fieldSchema.decodeComparableLength(bytes, cursor);
            }
            ++index;
        }
        return cursor - offset;
    }

    public T decodePrefix(byte[] bytes, int numFields) {
        ComparableBinaryDto dto = (ComparableBinaryDto)BinaryDtoAllocator.allocate(this.dtoClass);
        int cursor = 0;
        int index = 0;
        while (index < numFields) {
            BinaryDtoFieldSchema<?> fieldSchema = this.fieldSchemas.get(index);
            boolean isNull = false;
            if (fieldSchema.isNullable()) {
                isNull = BinaryDtoNullFieldTool.decodeNullIndicator(bytes[cursor]);
                ++cursor;
            }
            if (!isNull) {
                cursor += fieldSchema.decodeComparable(dto, bytes, cursor);
            }
            ++index;
        }
        return (T)dto;
    }
}

