/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes;

import io.datarouter.scanner.Scanner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;

public class InputStreamTool {
    public static void close(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static long count(InputStream inputStream, int bufferSize) {
        long count = 0L;
        try {
            int numRead;
            byte[] buffer = new byte[bufferSize];
            while ((numRead = inputStream.read(buffer)) != -1) {
                count += (long)numRead;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return count;
    }

    public static long countByte(InputStream inputStream, int bufferSize, byte matchByte) {
        long count = 0L;
        try {
            int numRead;
            byte[] buffer = new byte[bufferSize];
            while ((numRead = inputStream.read(buffer)) != -1) {
                int i = 0;
                while (i < numRead) {
                    if (buffer[i] == matchByte) {
                        ++count;
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return count;
    }

    public static byte[] readNBytes(InputStream inputStream, int len) {
        byte[] bytes = new byte[len];
        try {
            int numRead = inputStream.readNBytes(bytes, 0, len);
            if (numRead == len) {
                return bytes;
            }
            return Arrays.copyOfRange(bytes, 0, numRead);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Scanner<byte[]> scanChunks(InputStream inputStream, int chunkSize) {
        return Scanner.generate(() -> InputStreamTool.readNBytes(inputStream, chunkSize)).advanceWhile(chunk -> ((byte[])chunk).length > 0);
    }

    public static byte[] toArray(InputStream inputStream) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStreamTool.transferTo(inputStream, baos);
        return baos.toByteArray();
    }

    public static long transferTo(InputStream inputStream, OutputStream outputStream) {
        try {
            return inputStream.transferTo(outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

