/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.stringcodec;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class StringCodec {
    public static final StringCodec US_ASCII = new StringCodec(StandardCharsets.US_ASCII);
    public static final StringCodec ISO_8859_1 = new StringCodec(StandardCharsets.ISO_8859_1);
    public static final StringCodec UTF_8 = new StringCodec(StandardCharsets.UTF_8);
    private final String charsetName;

    public StringCodec(String charsetName) {
        if (!Charset.isSupported(charsetName)) {
            String message = String.format("Charset %s not supported", charsetName);
            throw new IllegalArgumentException(message);
        }
        this.charsetName = charsetName;
    }

    public StringCodec(Charset charset) {
        this.charsetName = charset.name();
    }

    public byte[] encode(String value) {
        try {
            return value.getBytes(this.charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public int encode(String value, byte[] bytes, int offset) {
        byte[] encodedBytes = this.encode(value);
        System.arraycopy(encodedBytes, 0, bytes, offset, encodedBytes.length);
        return encodedBytes.length;
    }

    public String decode(byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    public String decode(byte[] bytes, int offset) {
        int length = bytes.length - offset;
        return this.decode(bytes, offset, length);
    }

    public String decode(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, this.charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

