/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.codec.list.longlist;

import io.datarouter.bytes.EmptyArray;
import io.datarouter.bytes.codec.longcodec.ComparableLongCodec;
import java.util.ArrayList;
import java.util.List;

public class LongListCodec {
    public static final LongListCodec INSTANCE = new LongListCodec();
    private static final ComparableLongCodec COMPARABLE_LONG_CODEC = ComparableLongCodec.INSTANCE;
    private static final int ITEM_LENGTH = COMPARABLE_LONG_CODEC.length();

    public byte[] encode(List<Long> values) {
        if (values.size() == 0) {
            return EmptyArray.BYTE;
        }
        byte[] bytes = new byte[ITEM_LENGTH * values.size()];
        this.encode(values, bytes, 0);
        return bytes;
    }

    public int encode(List<Long> values, byte[] bytes, int offset) {
        int cursor = offset;
        int i = 0;
        while (i < values.size()) {
            COMPARABLE_LONG_CODEC.encode(values.get(i), bytes, cursor);
            cursor += ITEM_LENGTH;
            ++i;
        }
        return values.size() * ITEM_LENGTH;
    }

    public List<Long> decode(byte[] bytes) {
        return this.decode(bytes, 0, bytes.length);
    }

    public List<Long> decode(byte[] bytes, int offset, int bytesLength) {
        if (bytesLength == 0) {
            return new ArrayList<Long>(0);
        }
        if (bytesLength % ITEM_LENGTH != 0) {
            throw new IllegalArgumentException("bytesLength must be multiple of " + ITEM_LENGTH);
        }
        int resultLength = bytesLength / ITEM_LENGTH;
        ArrayList<Long> result = new ArrayList<Long>(resultLength);
        int cursor = offset;
        int i = 0;
        while (i < resultLength) {
            long value = COMPARABLE_LONG_CODEC.decode(bytes, cursor);
            cursor += ITEM_LENGTH;
            result.add(value);
            ++i;
        }
        return result;
    }
}

