/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.bytes.binarydto.internal;

import io.datarouter.bytes.LengthAndValue;
import io.datarouter.bytes.binarydto.fieldcodec.BinaryDtoBaseFieldCodec;
import io.datarouter.bytes.binarydto.internal.BinaryDtoFieldCodecs;
import io.datarouter.bytes.binarydto.internal.BinaryDtoFieldMetadataParser;
import io.datarouter.bytes.binarydto.internal.BinaryDtoNullFieldTool;
import io.datarouter.bytes.binarydto.internal.BinaryDtoReflectionTool;
import java.lang.reflect.Field;

public class BinaryDtoFieldSchema<F> {
    public final Field field;
    private final boolean isNullable;
    private final BinaryDtoBaseFieldCodec<F> codec;

    public BinaryDtoFieldSchema(Field field) {
        this.field = field;
        BinaryDtoFieldMetadataParser fieldMetadataParser = new BinaryDtoFieldMetadataParser(field);
        this.isNullable = fieldMetadataParser.isNullable();
        this.codec = BinaryDtoFieldCodecs.getCodecForField(field);
    }

    public String getName() {
        return this.field.getName();
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isNull(Object dto) {
        return this.getFieldValue(dto) == null;
    }

    public boolean isFixedLength() {
        return this.codec.isFixedLength();
    }

    public byte[] encodeValue(Object dto) {
        F fieldValue = this.getFieldValue(dto);
        return this.codec.encode(fieldValue);
    }

    public int decodeField(Object object, byte[] bytes, int offset) {
        int cursor = offset;
        F fieldValue = null;
        if (this.isNullable) {
            boolean isNull = BinaryDtoNullFieldTool.decodeNullIndicator(bytes[cursor]);
            ++cursor;
            if (!isNull) {
                if (this.codec.isFixedLength()) {
                    fieldValue = this.codec.decode(bytes, cursor);
                    cursor += this.codec.fixedLength();
                } else {
                    LengthAndValue<F> lengthAndValue = this.codec.decodeWithLength(bytes, cursor);
                    cursor += lengthAndValue.length;
                    fieldValue = (F)lengthAndValue.value;
                }
            }
        } else if (this.codec.isFixedLength()) {
            fieldValue = this.codec.decode(bytes, cursor);
            cursor += this.codec.fixedLength();
        } else {
            LengthAndValue<F> lengthAndValue = this.codec.decodeWithLength(bytes, cursor);
            cursor += lengthAndValue.length;
            fieldValue = (F)lengthAndValue.value;
        }
        this.setFieldValue(object, fieldValue);
        return cursor - offset;
    }

    public int decodeFieldLength(byte[] bytes, int offset) {
        int cursor = offset;
        if (this.isNullable) {
            boolean isNull = BinaryDtoNullFieldTool.decodeNullIndicator(bytes[cursor]);
            ++cursor;
            if (!isNull) {
                cursor += this.codec.decodeLength(bytes, cursor);
            }
        } else {
            cursor += this.codec.decodeLength(bytes, cursor);
        }
        return cursor - offset;
    }

    public int compareFieldValuesAsIfEncoded(Object left, Object right) {
        F leftValue = this.getFieldValue(left);
        F rightValue = this.getFieldValue(right);
        if (leftValue == null && rightValue == null) {
            return 0;
        }
        if (leftValue == null) {
            return -1;
        }
        if (rightValue == null) {
            return 1;
        }
        return this.codec.compareAsIfEncoded(leftValue, rightValue);
    }

    private F getFieldValue(Object dto) {
        return (F)BinaryDtoReflectionTool.getUnchecked(this.field, dto);
    }

    public void setFieldValue(Object dto, F fieldValue) {
        BinaryDtoReflectionTool.setUnchecked(this.field, dto, fieldValue);
    }
}

